/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.repeatedMeasures;

import dr.evolution.tree.TreeTrait;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.continuous.ConditionalTraitSimulationHelper;
import dr.evomodel.treedatalikelihood.continuous.ContinuousDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.preorder.AbstractRealizedContinuousTraitDelegate;
import dr.evomodel.treedatalikelihood.preorder.ModelExtensionProvider;
import dr.inference.distribution.DistributionLikelihood;
import dr.inference.distribution.LogNormalDistributionModel;
import dr.inference.distribution.NormalDistributionModel;
import dr.inference.model.CompoundParameter;
import dr.inference.model.DiagonalMatrix;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Parameter;
import dr.inference.operators.repeatedMeasures.MultiplicativeGammaGibbsHelper;
import dr.math.distributions.Distribution;
import dr.util.Attribute;
import java.util.List;

public interface GammaGibbsProvider {
    public SufficientStatistics getSufficientStatistics(int var1);

    public Parameter getPrecisionParameter();

    public void drawValues();

    public static class MultiplicativeGammaGibbsProvider
    implements GammaGibbsProvider {
        private final Parameter rowMultipliers;
        private final MultiplicativeGammaGibbsHelper helper;

        public MultiplicativeGammaGibbsProvider(Parameter parameter, MultiplicativeGammaGibbsHelper multiplicativeGammaGibbsHelper) {
            this.rowMultipliers = parameter;
            this.helper = multiplicativeGammaGibbsHelper;
        }

        @Override
        public SufficientStatistics getSufficientStatistics(int n) {
            double d = 0.0;
            int n2 = this.helper.getColumnDimension();
            int n3 = this.helper.getRowDimension();
            for (int i = n; i < n2; ++i) {
                double d2 = this.gpMult(i + 1, n);
                double d3 = this.helper.computeSumSquaredErrors(i);
                d += d2 * d3;
            }
            return new SufficientStatistics(n3 * (n2 - n), d);
        }

        @Override
        public Parameter getPrecisionParameter() {
            return this.rowMultipliers;
        }

        @Override
        public void drawValues() {
        }

        private double gpMult(int n, int n2) {
            double d = 1.0;
            for (int i = 0; i < n; ++i) {
                if (i == n2) continue;
                d *= this.rowMultipliers.getParameterValue(i);
            }
            return d;
        }
    }

    public static class NormalExtensionGibbsProvider
    implements GammaGibbsProvider {
        private final ModelExtensionProvider.NormalExtensionProvider dataModel;
        private final TreeDataLikelihood treeLikelihood;
        private final ConditionalTraitSimulationHelper traitProvider;
        private final TreeTrait tipTrait;
        private final CompoundParameter traitParameter;
        private final Parameter precisionParameter;
        private final boolean[] missingVector;
        private double[] tipValues;
        private boolean hasCheckedDimension = false;
        private static final boolean DEBUG = false;

        public NormalExtensionGibbsProvider(ModelExtensionProvider.NormalExtensionProvider normalExtensionProvider, TreeDataLikelihood treeDataLikelihood, String string) {
            this.dataModel = normalExtensionProvider;
            this.treeLikelihood = treeDataLikelihood;
            this.traitParameter = normalExtensionProvider.getParameter();
            this.missingVector = normalExtensionProvider.getDataMissingIndicators();
            if (string == null) {
                this.tipTrait = null;
                this.traitProvider = ((ContinuousDataLikelihoodDelegate)treeDataLikelihood.getDataLikelihoodDelegate()).getExtensionHelper();
            } else {
                this.tipTrait = treeDataLikelihood.getTreeTrait(AbstractRealizedContinuousTraitDelegate.getTipTraitName(string));
                this.traitProvider = null;
            }
            MatrixParameterInterface matrixParameterInterface = normalExtensionProvider.getExtensionPrecision();
            if (!(matrixParameterInterface instanceof DiagonalMatrix)) {
                throw new RuntimeException(this.getClass().getName() + " only applies to diagonal precision matrices, but the " + ModelExtensionProvider.NormalExtensionProvider.class.getName() + " supplied a precision matrix of class " + matrixParameterInterface.getClass().getName() + ".");
            }
            this.precisionParameter = ((DiagonalMatrix)matrixParameterInterface).getDiagonalParameter();
        }

        @Override
        public SufficientStatistics getSufficientStatistics(int n) {
            int n2 = this.treeLikelihood.getTree().getExternalNodeCount();
            int n3 = this.dataModel.getDataDimension();
            if (!this.hasCheckedDimension) {
                if (n2 * n3 != this.tipValues.length) {
                    throw new RuntimeException("dimensions are incompatible");
                }
                this.hasCheckedDimension = true;
            }
            int n4 = 0;
            double d = 0.0;
            for (int i = 0; i < n2; ++i) {
                int n5 = n3 * i;
                if (this.missingVector == null || !this.missingVector[n + n5]) {
                    double d2 = this.traitParameter.getParameter(i).getParameterValue(n);
                    double d3 = this.tipValues[i * n3 + n];
                    d += (d2 - d3) * (d2 - d3);
                    continue;
                }
                ++n4;
            }
            return new SufficientStatistics(n2 - n4, d);
        }

        @Override
        public Parameter getPrecisionParameter() {
            return this.precisionParameter;
        }

        @Override
        public void drawValues() {
            double[] dArray = this.tipTrait == null ? this.traitProvider.drawTraitsAbove(this.dataModel) : (double[])this.tipTrait.getTrait(this.treeLikelihood.getTree(), null);
            this.tipValues = this.dataModel.transformTreeTraits(dArray);
        }
    }

    public static class Default
    implements GammaGibbsProvider {
        private final Parameter precisionParameter;
        private final Parameter meanParameter;
        private final boolean isLog;
        private final List<Attribute<double[]>> dataList;

        public Default(DistributionLikelihood distributionLikelihood) {
            Distribution distribution = distributionLikelihood.getDistribution();
            this.dataList = distributionLikelihood.getDataList();
            if (distribution instanceof NormalDistributionModel) {
                this.precisionParameter = (Parameter)((NormalDistributionModel)distribution).getPrecision();
                this.meanParameter = (Parameter)((NormalDistributionModel)distribution).getMean();
                this.isLog = false;
            } else if (distribution instanceof LogNormalDistributionModel) {
                if (((LogNormalDistributionModel)distribution).getParameterization() != LogNormalDistributionModel.Parameterization.MU_PRECISION) {
                    throw new RuntimeException("Must characterize likelihood in terms of mu and precision parameters");
                }
                this.meanParameter = ((LogNormalDistributionModel)distribution).getMuParameter();
                this.precisionParameter = ((LogNormalDistributionModel)distribution).getPrecisionParameter();
                this.isLog = true;
            } else {
                throw new RuntimeException("Likelihood must be Normal or log Normal");
            }
            if (this.precisionParameter == null) {
                throw new RuntimeException("Must characterize likelihood in terms of a precision parameter");
            }
        }

        @Override
        public SufficientStatistics getSufficientStatistics(int n) {
            double d = this.meanParameter.getParameterValue(n);
            double d2 = 0.0;
            int n2 = 0;
            for (Attribute<double[]> attribute : this.dataList) {
                for (double d3 : attribute.getAttributeValue()) {
                    if (this.isLog) {
                        double d4 = Math.log(d3);
                        d2 += (d4 - d) * (d4 - d);
                    } else {
                        d2 += (d3 - d) * (d3 - d);
                    }
                    ++n2;
                }
            }
            return new SufficientStatistics(n2, d2);
        }

        @Override
        public Parameter getPrecisionParameter() {
            return this.precisionParameter;
        }

        @Override
        public void drawValues() {
        }
    }

    public static class SufficientStatistics {
        public final int observationCount;
        public final double sumOfSquaredErrors;

        public SufficientStatistics(int n, double d) {
            this.observationCount = n;
            this.sumOfSquaredErrors = d;
        }
    }
}

