/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.demographicmodel;

import dr.evolution.coalescent.ConstExponential;
import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.util.Units;
import dr.evomodel.coalescent.demographicmodel.DemographicModel;
import dr.inference.model.Parameter;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.Collections;
import java.util.List;

public class ConstantExponentialModel
extends DemographicModel
implements Citable {
    Parameter N0Parameter = null;
    Parameter timeParameter = null;
    Parameter growthRateParameter = null;
    ConstExponential constExponential = null;
    boolean usingGrowthRate = true;
    public static Citation CITATION = new Citation(new Author[]{new Author("OG", "Pybus"), new Author("A", "Rambaut")}, "GENIE: estimating demographic history from molecular phylogenies", 2001, "Bioinformatics", 18, 1404, 1405);

    public ConstantExponentialModel(Parameter parameter, Parameter parameter2, Parameter parameter3, Units.Type type, boolean bl) {
        this("constantExponential", parameter, parameter2, parameter3, type, bl);
    }

    public ConstantExponentialModel(String string, Parameter parameter, Parameter parameter2, Parameter parameter3, Units.Type type, boolean bl) {
        super(string);
        this.constExponential = new ConstExponential(type);
        this.N0Parameter = parameter;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.timeParameter = parameter2;
        this.addVariable(parameter2);
        parameter2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.growthRateParameter = parameter3;
        this.addVariable(parameter3);
        parameter3.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.usingGrowthRate = bl;
        this.setUnits(type);
    }

    @Override
    public DemographicFunction getDemographicFunction() {
        double d = this.timeParameter.getParameterValue(0) - this.getTimeOffset();
        double d2 = this.N0Parameter.getParameterValue(0);
        double d3 = this.growthRateParameter.getParameterValue(0);
        if (!this.usingGrowthRate) {
            double d4 = d3;
            d3 = Math.log(2.0) / d4;
        }
        this.constExponential.setGrowthRate(d3);
        this.constExponential.setN0(d2);
        this.constExponential.setN1(d2 * Math.exp(-d * d3));
        return this.constExponential;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TREE_PRIORS;
    }

    @Override
    public String getDescription() {
        return "Constant-Exponential Coalescent";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CITATION);
    }
}

