/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.experimentertab;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import moa.gui.experimentertab.ImageChart;
import moa.gui.experimentertab.ImageTreePanel;
import nz.ac.waikato.cms.gui.core.BaseDirectoryChooser;

public class ImageViewer
extends JFrame {
    private ImageTreePanel imgPanel;
    private String resultsPath;
    private JButton btn;
    private JComboBox imgType;

    public ImageViewer(ImageTreePanel imgPanel, String resultsPath) throws HeadlessException {
        super("Preview");
        this.imgPanel = imgPanel;
        this.resultsPath = resultsPath;
        this.setDefaultCloseOperation(1);
        JPanel panel = new JPanel();
        JPanel main = new JPanel();
        JLabel label = new JLabel("Output format");
        String[] op = new String[]{"PNG", "JPG", "SVG"};
        this.imgType = new JComboBox<String>(op);
        this.imgType.setSelectedIndex(0);
        this.btn = new JButton("Save all images as...");
        this.btn.addActionListener(this::btnMenuActionPerformed);
        panel.add(label);
        panel.add(this.imgType);
        panel.add(this.btn);
        main.setLayout(new BorderLayout());
        main.add((Component)this.imgPanel, "Center");
        main.add((Component)panel, "South");
        this.setContentPane(main);
        this.pack();
        this.setSize(700, 500);
        this.setVisible(true);
    }

    private void btnMenuActionPerformed(ActionEvent evt) {
        String path = "";
        BaseDirectoryChooser propDir = new BaseDirectoryChooser();
        propDir.setFileSelectionMode(1);
        propDir.setCurrentDirectory(new File(this.resultsPath));
        int selection = propDir.showSaveDialog((Component)this);
        if (selection == 0 && !(path = propDir.getSelectedFile().getAbsolutePath()).equals("")) {
            for (ImageChart chart : this.imgPanel.getChart()) {
                try {
                    chart.exportIMG(path, this.imgType.getSelectedItem().toString());
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this, "Error creating image " + chart.getName());
                    return;
                }
            }
            JOptionPane.showMessageDialog(this, "Images saved at: " + path);
        }
    }
}

