/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view.set;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.ISetDelta;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.solver.variables.view.SetView;
import org.chocosolver.solver.variables.view.delta.SetViewOnSetsDeltaMonitor;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.objects.setDataStructures.dynamic.SetDifference;
import org.chocosolver.util.objects.setDataStructures.dynamic.SetUnion;
import org.chocosolver.util.procedure.IntProcedure;

public class SetUnionView
extends SetView<SetVar> {
    protected SetUnion lb;
    protected SetUnion ub;
    protected ISet enforce = SetFactory.makeStoredSet(SetType.RANGESET, 0, this.getModel());

    public SetUnionView(String name, SetVar ... variables) {
        super(name, (Variable[])variables);
        ISet[] LBs = new ISet[variables.length + 1];
        ISet[] UBs = new ISet[variables.length];
        for (int i = 0; i < variables.length; ++i) {
            LBs[i] = variables[i].getLB();
            UBs[i] = variables[i].getUB();
        }
        LBs[variables.length] = this.enforce;
        this.lb = new SetUnion(this.getModel(), LBs);
        this.ub = new SetUnion(this.getModel(), UBs);
    }

    @Override
    public ISet getLB() {
        return this.lb;
    }

    @Override
    public ISet getUB() {
        return this.ub;
    }

    @Override
    public boolean instantiateTo(int[] value, ICause cause) throws ContradictionException {
        return false;
    }

    @Override
    public boolean isInstantiated() {
        return this.getLB().size() == this.getUB().size();
    }

    @Override
    public void notify(IEventType event, int variableIdx) throws ContradictionException {
        if ((event.getMask() & SetEventType.REMOVE_FROM_ENVELOPE.getMask()) > 0) {
            ISetIterator iSetIterator = this.enforce.iterator();
            while (iSetIterator.hasNext()) {
                int i = (Integer)iSetIterator.next();
                if (!this.doForceSetElement(i)) continue;
                this.enforce.remove(i);
                break;
            }
        }
        this.notifyPropagators(event, this);
    }

    @Override
    protected boolean doRemoveSetElement(int element) throws ContradictionException {
        if (this.enforce.contains(element)) {
            this.contradiction(this, "Try to remove mandatory element");
        }
        boolean b = false;
        for (SetVar set : (SetVar[])this.variables) {
            b |= set.remove(element, this);
        }
        return b;
    }

    @Override
    protected boolean doForceSetElement(int element) throws ContradictionException {
        int nb = 0;
        int idx = -1;
        for (int i = 0; i < ((SetVar[])this.variables).length; ++i) {
            if (!((SetVar[])this.variables)[i].getUB().contains(element)) continue;
            idx = i;
            if (++nb > 1) break;
        }
        if (nb == 1) {
            return ((SetVar[])this.variables)[idx].force(element, this);
        }
        this.enforce.add(element);
        return false;
    }

    @Override
    public ISetDelta getDelta() {
        throw new UnsupportedOperationException("SetUnionView does not support getDelta()");
    }

    @Override
    public ISetDeltaMonitor monitorDelta(ICause propagator) {
        ISetDeltaMonitor[] deltaMonitors = new ISetDeltaMonitor[((SetVar[])this.variables).length];
        for (int i = 0; i < ((SetVar[])this.variables).length; ++i) {
            deltaMonitors[i] = ((SetVar[])this.variables)[i].monitorDelta(propagator);
        }
        return new SetViewOnSetsDeltaMonitor(deltaMonitors){
            final ISet remove;
            final ISet added;
            final ISet add;
            {
                this.remove = new SetUnion(this.removedValues);
                this.added = SetFactory.makeStoredSet(SetType.RANGESET, 0, SetUnionView.this.getModel());
                this.add = new SetDifference(new SetUnion(this.addedValues), this.added);
            }

            @Override
            public void forEach(IntProcedure proc, SetEventType evt) throws ContradictionException {
                block4: {
                    block3: {
                        int v;
                        this.fillValues();
                        if (evt != SetEventType.ADD_TO_KER) break block3;
                        ISetIterator iSetIterator = this.add.iterator();
                        while (iSetIterator.hasNext()) {
                            v = (Integer)iSetIterator.next();
                            proc.execute(v);
                        }
                        iSetIterator = this.add.iterator();
                        while (iSetIterator.hasNext()) {
                            v = (Integer)iSetIterator.next();
                            this.added.add(v);
                        }
                        break block4;
                    }
                    if (evt != SetEventType.REMOVE_FROM_ENVELOPE) break block4;
                    ISetIterator iSetIterator = this.remove.iterator();
                    while (iSetIterator.hasNext()) {
                        int v = (Integer)iSetIterator.next();
                        if (SetUnionView.this.getUB().contains(v)) continue;
                        proc.execute(v);
                    }
                }
            }
        };
    }
}

