## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(redistmetrics)
data(nh)

## ----echo = FALSE-------------------------------------------------------------
library(ggplot2)

nh %>% 
  ggplot() +
  geom_sf(aes(fill = as.character(r_2020))) + 
  labs(fill = 'none')

## -----------------------------------------------------------------------------
comp_polsby(plans = nh$r_2020, shp = nh)

## -----------------------------------------------------------------------------
comp_schwartz(plans = nh$r_2020, shp = nh)

## -----------------------------------------------------------------------------
comp_reock(plans = nh$r_2020, shp = nh)

## -----------------------------------------------------------------------------
comp_box_reock(plans = nh$r_2020, shp = nh)

## -----------------------------------------------------------------------------
comp_ch(plans = nh$r_2020, shp = nh)

## -----------------------------------------------------------------------------
comp_skew(plans = nh$r_2020, shp = nh)

## -----------------------------------------------------------------------------
comp_x_sym(plans = nh$r_2020, shp = nh)

## -----------------------------------------------------------------------------
comp_y_sym(plans = nh$r_2020, shp = nh)

## -----------------------------------------------------------------------------
comp_lw(plans = nh$r_2020, shp = nh)

## -----------------------------------------------------------------------------
comp_bc(plans = nh$r_2020, shp = nh)

## -----------------------------------------------------------------------------
comp_fh(plans = nh$r_2020, shp = nh, total_pop = pop)

## -----------------------------------------------------------------------------
comp_edges_rem(plans = nh$r_2020, shp = nh, adj = nh$adj)

## -----------------------------------------------------------------------------
comp_frac_kept(plans = nh$r_2020, shp = nh, adj = nh$adj)

## -----------------------------------------------------------------------------
comp_log_st(plans = nh$r_2020, shp = nh, adj = nh$adj, counties = county)

