/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Value;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FieldUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.xgboost.GBTree;
import org.jpmml.xgboost.IntegerRange;
import org.jpmml.xgboost.Learner;

public class FeatureMap {
    private List<Entry> entries = new ArrayList<Entry>();
    private Map<Value.Property, List<String>> valueMap = new EnumMap<Value.Property, List<String>>(Value.Property.class);

    public List<Feature> encodeFeatures(Learner learner, PMMLEncoder encoder) {
        List<Entry> entries = this.getEntries();
        ArrayList<Feature> result = new ArrayList<Feature>();
        LinkedHashSet<DataField> dataFields = new LinkedHashSet<DataField>();
        for (int i = 0; i < entries.size(); ++i) {
            Entry entry = entries.get(i);
            Feature feature = entry.encodeFeature(learner, i, encoder);
            result.add(feature);
            DataField dataField = (DataField)feature.getField();
            dataFields.add(dataField);
        }
        Set<Map.Entry<Value.Property, List<String>>> valueEntries = this.valueMap.entrySet();
        for (DataField dataField : dataFields) {
            for (Map.Entry entry : valueEntries) {
                FieldUtil.addValues((Field)dataField, (Value.Property)((Value.Property)entry.getKey()), (List)((List)entry.getValue()));
            }
        }
        return result;
    }

    public boolean isEmpty() {
        List<Entry> entries = this.getEntries();
        return entries.isEmpty();
    }

    public void update(FeatureMap featureMap) {
        List<Entry> entries = this.getEntries();
        for (Entry entry : entries) {
            List<Entry> updateEntries = featureMap.getEntries(entry.getName());
            if (updateEntries.isEmpty()) {
                throw new IllegalArgumentException("Feature '" + entry.getName() + "' has no feature map entries");
            }
            if (!(entry instanceof CategoricalEntry)) continue;
            CategoricalEntry categoricalEntry = (CategoricalEntry)entry;
            List values = updateEntries.stream().map(IndicatorEntry.class::cast).map(IndicatorEntry::getValue).collect(Collectors.toList());
            categoricalEntry.setValues(values);
        }
    }

    public void addEntry(String name, String type) {
        Entry entry = FeatureMap.createEntry(name, Entry.Type.fromString(type));
        this.addEntry(entry);
    }

    public void addEntry(Entry entry) {
        List<Entry> entries = this.getEntries();
        entries.add(entry);
    }

    public List<Entry> getEntries(String name) {
        ArrayList<Entry> result = new ArrayList<Entry>();
        List<Entry> entries = this.getEntries();
        for (Entry entry : entries) {
            if (!Objects.equals(name, entry.getName())) continue;
            result.add(entry);
        }
        return result;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public void addValidValue(String value) {
        this.addValue(Value.Property.VALID, value);
    }

    public void addInvalidValue(String value) {
        this.addValue(Value.Property.INVALID, value);
    }

    public void addMissingValue(String value) {
        this.addValue(Value.Property.MISSING, value);
    }

    private void addValue(Value.Property property, String value) {
        if (value == null) {
            return;
        }
        List<String> values = this.valueMap.get(property);
        if (values == null) {
            values = new ArrayList<String>();
            this.valueMap.put(property, values);
        }
        values.add(value);
    }

    private static Entry createEntry(String name, Entry.Type type) {
        switch (type) {
            case INDICATOR: {
                String value = null;
                int equals = name.indexOf(61);
                if (equals > -1) {
                    value = name.substring(equals + 1);
                    name = name.substring(0, equals);
                }
                return new IndicatorEntry(name, value, type);
            }
            case QUANTITIVE: 
            case INTEGER: 
            case FLOAT: {
                return new ContinuousEntry(name, type);
            }
            case CATEGORICAL: {
                return new CategoricalEntry(name, type);
            }
        }
        throw new IllegalArgumentException();
    }

    public static class CategoricalEntry
    extends Entry {
        private List<?> values = null;

        public CategoricalEntry(String name, Entry.Type type) {
            super(name, type);
        }

        @Override
        public Feature encodeFeature(Learner learner, int index, PMMLEncoder encoder) {
            DataField dataField;
            String name = this.getName();
            Entry.Type type = this.getType();
            IntegerRange values = this.getValues();
            DataType dataType = DataType.STRING;
            if (values == null) {
                GBTree gbtree = learner.gbtree();
                BitSet splitIndices = gbtree.getSplitCategories(index);
                if (splitIndices != null) {
                    int size = Math.max(splitIndices.length(), 2);
                    values = new IntegerRange(size);
                } else {
                    values = new IntegerRange(1);
                }
                dataType = DataType.INTEGER;
            }
            if ((dataField = encoder.getDataField(name)) == null) {
                switch (type) {
                    case CATEGORICAL: {
                        dataField = encoder.createDataField(name, OpType.CATEGORICAL, dataType, (List)values);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            return new CategoricalFeature(encoder, (Field)dataField, values);
        }

        public List<?> getValues() {
            return this.values;
        }

        private void setValues(List<?> values) {
            this.values = values;
        }
    }

    public static class ContinuousEntry
    extends Entry {
        public ContinuousEntry(String name, Entry.Type type) {
            super(name, type);
        }

        @Override
        public Feature encodeFeature(Learner learner, int index, PMMLEncoder encoder) {
            String name = this.getName();
            Entry.Type type = this.getType();
            DataField dataField = encoder.getDataField(name);
            if (dataField == null) {
                switch (type) {
                    case QUANTITIVE: {
                        dataField = encoder.createDataField(name, OpType.CONTINUOUS, DataType.FLOAT);
                        break;
                    }
                    case INTEGER: {
                        dataField = encoder.createDataField(name, OpType.CONTINUOUS, DataType.INTEGER);
                        break;
                    }
                    case FLOAT: {
                        dataField = encoder.createDataField(name, OpType.CONTINUOUS, DataType.FLOAT);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            return new ContinuousFeature(encoder, (Field)dataField);
        }
    }

    public static class IndicatorEntry
    extends Entry {
        private String value = null;

        public IndicatorEntry(String name, String value, Entry.Type type) {
            super(name, type);
            this.setValue(value);
        }

        @Override
        public Feature encodeFeature(Learner learner, int index, PMMLEncoder encoder) {
            String name = this.getName();
            String value = this.getValue();
            Entry.Type type = this.getType();
            DataField dataField = encoder.getDataField(name);
            if (dataField == null) {
                switch (type) {
                    case INDICATOR: {
                        if (value != null) {
                            dataField = encoder.createDataField(name, OpType.CATEGORICAL, DataType.STRING);
                            break;
                        }
                        dataField = encoder.createDataField(name, OpType.CATEGORICAL, DataType.BOOLEAN);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            if (value != null) {
                FieldUtil.addValues((Field)dataField, Collections.singletonList(value));
                return new BinaryFeature(encoder, (Field)dataField, (Object)value);
            }
            return new BinaryFeature(encoder, (Field)dataField, (Object)Boolean.TRUE);
        }

        public String getValue() {
            return this.value;
        }

        private void setValue(String value) {
            this.value = value;
        }
    }

    public static abstract class Entry {
        private String name = null;
        private Type type = null;

        public Entry(String name, Type type) {
            this.setName(name);
            this.setType(type);
        }

        public abstract Feature encodeFeature(Learner var1, int var2, PMMLEncoder var3);

        public String getName() {
            return this.name;
        }

        private void setName(String name) {
            this.name = Objects.requireNonNull(name);
        }

        public Type getType() {
            return this.type;
        }

        private void setType(Type type) {
            this.type = Objects.requireNonNull(type);
        }

        public static enum Type {
            INDICATOR,
            QUANTITIVE,
            INTEGER,
            FLOAT,
            CATEGORICAL;


            public static Type fromString(String string) {
                switch (string) {
                    case "i": {
                        return INDICATOR;
                    }
                    case "q": {
                        return QUANTITIVE;
                    }
                    case "int": {
                        return INTEGER;
                    }
                    case "float": {
                        return FLOAT;
                    }
                    case "c": 
                    case "categorical": {
                        return CATEGORICAL;
                    }
                }
                throw new IllegalArgumentException(string);
            }
        }
    }
}

