/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Rule_Learning.ART;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.util.Vector;
import keel.Algorithms.Rule_Learning.ART.Algorithm;
import keel.Algorithms.Rule_Learning.ART.Attribute;
import keel.Algorithms.Rule_Learning.ART.Dataset;
import keel.Algorithms.Rule_Learning.ART.Itemset;
import keel.Algorithms.Rule_Learning.ART.Node;
import keel.Algorithms.Rule_Learning.ART.Rule;
import keel.Algorithms.Rule_Learning.ART.TBAR;
import keel.Dataset.Attributes;

public class ART
extends Algorithm {
    Node root = new Node();
    int NumberOfNodes;
    int NumberOfLeafs;
    int MaxSize;
    double MinSupp = 0.1;
    double MinConf = 1.0;

    public ART(String paramFile) {
        boolean salir = false;
        try {
            long startTime = System.currentTimeMillis();
            StreamTokenizer tokenizer = new StreamTokenizer(new BufferedReader(new FileReader(paramFile)));
            this.initTokenizer(tokenizer);
            this.setOptions(tokenizer);
            this.modelDataset = new Dataset(modelFileName, true);
            if (Attributes.hasRealAttributes() || Attributes.hasIntegerAttributes()) {
                System.err.println("ART can only handle nominal attributes.");
                salir = true;
            }
            if (!salir) {
                this.trainDataset = new Dataset(trainFileName, false);
                this.testDataset = new Dataset(testFileName, false);
                this.NumberOfNodes = 1;
                this.NumberOfLeafs = 0;
                this.generateTree();
                this.printTrain();
                this.printTest();
                this.printResult();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void setOptions(StreamTokenizer options) throws Exception {
        options.nextToken();
        if (options.sval.equalsIgnoreCase("algorithm")) {
            options.nextToken();
            options.nextToken();
            options.nextToken();
            options.nextToken();
            if (options.sval.equalsIgnoreCase("inputData")) {
                options.nextToken();
                options.nextToken();
                modelFileName = options.sval;
                if (options.nextToken() != 10) {
                    trainFileName = options.sval;
                    options.nextToken();
                    testFileName = options.sval;
                    if (options.nextToken() != 10) {
                        trainFileName = modelFileName;
                        options.nextToken();
                    }
                }
            } else {
                throw new Exception("The file must start with the word inputData.");
            }
            do {
                if (options.nextToken() != -1) continue;
                throw new Exception("No output file provided.");
            } while (options.sval == null || !options.sval.equalsIgnoreCase("outputData"));
        } else {
            throw new Exception("The file must start with the word algorithm followed of the name of the algorithm.");
        }
        options.nextToken();
        options.nextToken();
        trainOutputFileName = options.sval;
        options.nextToken();
        testOutputFileName = options.sval;
        options.nextToken();
        resultFileName = options.sval;
    }

    public void generateTree() {
        Vector data = new Vector(this.getItemsets());
        this.MaxSize = this.trainDataset.numAttributes() - 1;
        this.root.setData(data);
        this.art(data, this.root);
    }

    private void art(Vector data, Node nodo) {
        int k = 1;
        double corte = this.MinConf - this.MinSupp;
        TBAR tbar = new TBAR(this.MaxSize, this.MinSupp, data, this.trainDataset.attributes);
        Vector<Object> conjunto = new Vector();
        int supp = 0;
        while (k <= this.MaxSize && nodo.getAttributes().size() == 0) {
            Vector<Vector<Rule>> conjuntos = tbar.ruleExtraction(k);
            if (conjuntos.size() > 0) {
                double confidence = conjuntos.get(0).get(0).getConfidence();
                if (confidence >= corte) {
                    int i;
                    int maxSupp = 0;
                    for (i = 0; i < conjuntos.size(); ++i) {
                        supp = 0;
                        Vector<Rule> c = conjuntos.get(i);
                        for (int j = 0; j < c.size(); ++j) {
                            supp += c.get(j).getSupport();
                        }
                        if (supp <= maxSupp) continue;
                        maxSupp = supp;
                        conjunto = c;
                    }
                    nodo.setAttributes(((Rule)conjunto.get(0)).getAttributes());
                    nodo.setValues(null);
                    nodo.setSupport(data.size());
                    Vector<Node> children = new Vector<Node>();
                    for (i = 0; i < conjunto.size(); ++i) {
                        Node n = new Node();
                        n.setAttributes(null);
                        n.setValues(((Rule)conjunto.get(i)).getValues());
                        n.setClas(((Rule)conjunto.get(i)).getClas());
                        n.setSupport(((Rule)conjunto.get(i)).getSupport());
                        n.setParent(nodo);
                        children.add(n);
                        ++this.NumberOfNodes;
                    }
                    nodo.setChildren(children);
                    this.NumberOfLeafs += children.size();
                    Vector datos = this.uncoveredData(data, nodo);
                    nodo.setData(null);
                    if (datos.size() <= 0) continue;
                    Node n = new Node();
                    n.setParent(nodo);
                    n.setData(datos);
                    n.setSupport(datos.size());
                    children.add(n);
                    ++this.NumberOfNodes;
                    this.art(datos, nodo.getChildren(nodo.numChildren() - 1));
                    continue;
                }
                ++k;
                continue;
            }
            ++k;
        }
        if (nodo.getAttributes().size() == 0) {
            int index = this.mostFrequentClass(data);
            nodo.setClas(index);
            nodo.setSupport(data.size());
        }
    }

    private int mostFrequentClass(Vector<Itemset> data) {
        int i;
        Attribute a = this.trainDataset.getClassAttribute();
        int[] frequencies = new int[a.numValues()];
        int max = 0;
        int clas = -1;
        for (i = 0; i < frequencies.length; ++i) {
            frequencies[i] = 0;
        }
        for (i = 0; i < data.size(); ++i) {
            double index = data.get(i).getClassValue();
            int n = (int)index;
            frequencies[n] = frequencies[n] + 1;
        }
        for (i = 0; i < frequencies.length; ++i) {
            if (frequencies[i] <= max) continue;
            max = frequencies[i];
            clas = i;
        }
        return clas;
    }

    private Vector uncoveredData(Vector data, Node n) {
        Vector<Itemset> datos = new Vector<Itemset>();
        Vector<Integer> ats = n.getAttributes();
        for (int i = 0; i < data.size(); ++i) {
            Itemset item = (Itemset)data.get(i);
            int j = 0;
            boolean enc = false;
            while (j < n.numChildren() && !enc) {
                Vector<Integer> vals = n.getChildren(j).getValues();
                if (this.covered(ats, vals, item)) {
                    n.getChildren(j).addData(item);
                    enc = true;
                    continue;
                }
                ++j;
            }
            if (enc) continue;
            datos.add(item);
        }
        return datos;
    }

    private boolean covered(Vector<Integer> ats, Vector<Integer> vals, Itemset item) {
        boolean cover = true;
        int i = 0;
        while (i < ats.size() && cover) {
            if (item.getValue(ats.get(i)) != (double)vals.get(i).intValue()) {
                cover = false;
                continue;
            }
            ++i;
        }
        return cover;
    }

    public String writeTree(Node node, String tab) {
        int outputattr = this.modelDataset.getClassIndex();
        String cadena = "";
        Attribute classAtt = this.modelDataset.getClassAttribute();
        String attName = classAtt.name();
        try {
            if (node.numChildren() == 0) {
                String value = classAtt.value(node.getClas());
                if (node.getParent() != null) {
                    Vector<Integer> ats = node.getParent().getAttributes();
                    Vector<Integer> vals = node.getValues();
                    if (vals.size() != 0) {
                        cadena = cadena + tab + "if( ";
                        for (int i = 0; i < ats.size(); ++i) {
                            cadena = cadena + this.modelDataset.getAttribute(ats.get(i)).name() + "==" + this.modelDataset.getAttribute(ats.get(i)).value(vals.get(i)) + " ) and (";
                        }
                        cadena = cadena.substring(0, cadena.length() - 5);
                        cadena = cadena + " then {\n";
                    }
                }
                cadena = cadena + tab + "\t" + attName + " = \"" + value + "\"\n";
                return cadena;
            }
            for (int i = 0; i < node.numChildren(); ++i) {
                cadena = i == 0 ? cadena + this.writeTree(node.getChildren().get(i), tab) : cadena + this.writeTree(node.getChildren().get(i), tab + "\t");
                cadena = cadena + tab + "}else{\n";
            }
            cadena = cadena.substring(0, cadena.length() - 7);
            cadena = cadena + "\n" + tab + "}";
            return cadena;
        }
        catch (Exception e) {
            System.out.println("Error writing tree");
            return cadena;
        }
    }

    public int evaluateItemset(Itemset itemset, Node node) {
        int outputattr = this.modelDataset.getClassIndex();
        boolean correct = false;
        String aux = null;
        Attribute classAtt = this.modelDataset.getClassAttribute();
        try {
            if (node.numChildren() == 0) {
                return node.getClas();
            }
        }
        catch (Exception e) {
            return Integer.parseInt(aux.toString());
        }
        int i = 0;
        boolean enc = false;
        while (i < node.numChildren() - 1 && !enc) {
            if (this.covered(node.getAttributes(), node.getChildren(i).getValues(), itemset)) {
                enc = true;
                continue;
            }
            ++i;
        }
        if (enc) {
            return this.evaluateItemset(itemset, node.getChildren(i));
        }
        return this.evaluateItemset(itemset, node.getChildren(node.numChildren() - 1));
    }

    private Vector getItemsets() {
        Vector<Itemset> itemsets = new Vector<Itemset>(this.modelDataset.numItemsets());
        for (int i = 0; i < this.modelDataset.numItemsets(); ++i) {
            itemsets.addElement(this.modelDataset.itemset(i));
        }
        return itemsets;
    }

    @Override
    public void printResult() throws IOException {
        long totalTime = (System.currentTimeMillis() - this.startTime) / 1000L;
        long seconds = totalTime % 60L;
        long minutes = (totalTime - seconds) % 3600L / 60L;
        String tree = "";
        tree = tree + this.writeTree(this.root, "");
        tree = tree + "\n@TotalNumberOfNodes " + this.NumberOfNodes;
        tree = tree + "\n@NumberOfLeafs " + this.NumberOfLeafs;
        tree = tree + "\n\n@NumberOfItemsetsTraining " + this.trainDataset.numItemsets();
        tree = tree + "\n@NumberOfCorrectlyClassifiedTraining " + this.correct;
        tree = tree + "\n@PercentageOfCorrectlyClassifiedTraining " + (float)((double)this.correct * 100.0) / (float)this.trainDataset.numItemsets() + "%";
        tree = tree + "\n@NumberOfInCorrectlyClassifiedTraining " + (this.trainDataset.numItemsets() - this.correct);
        tree = tree + "\n@PercentageOfInCorrectlyClassifiedTraining " + (float)((double)(this.trainDataset.numItemsets() - this.correct) * 100.0) / (float)this.trainDataset.numItemsets() + "%";
        tree = tree + "\n\n@NumberOfItemsetsTest " + this.testDataset.numItemsets();
        tree = tree + "\n@NumberOfCorrectlyClassifiedTest " + this.testCorrect;
        tree = tree + "\n@PercentageOfCorrectlyClassifiedTest " + (float)((double)this.testCorrect * 100.0) / (float)this.testDataset.numItemsets() + "%";
        tree = tree + "\n@NumberOfInCorrectlyClassifiedTest " + (this.testDataset.numItemsets() - this.testCorrect);
        tree = tree + "\n@PercentageOfInCorrectlyClassifiedTest " + (float)((double)(this.testDataset.numItemsets() - this.testCorrect) * 100.0) / (float)this.testDataset.numItemsets() + "%";
        tree = tree + "\n\n@ElapsedTime " + (totalTime - minutes * 60L - seconds) / 3600L + ":" + minutes / 60L + ":" + seconds;
        PrintWriter resultPrint = new PrintWriter(new FileWriter(resultFileName));
        resultPrint.print(this.getHeader() + "\n@decisiontree\n\n" + tree);
        resultPrint.close();
    }

    @Override
    public void printTrain() {
        String text = this.getHeader();
        for (int i = 0; i < this.trainDataset.numItemsets(); ++i) {
            try {
                Itemset itemset = this.trainDataset.itemset(i);
                int cl = this.evaluateItemset(itemset, this.root);
                if (cl == (int)itemset.getValue(this.trainDataset.getClassIndex())) {
                    ++this.correct;
                }
                text = text + this.trainDataset.getClassAttribute().value(cl) + " " + this.trainDataset.getClassAttribute().value((int)itemset.getClassValue()) + "\n";
                continue;
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
        try {
            PrintWriter print = new PrintWriter(new FileWriter(trainOutputFileName));
            print.print(text);
            print.close();
        }
        catch (IOException e) {
            System.err.println("Can not open the training output file: " + e.getMessage());
        }
    }

    @Override
    public void printTest() {
        String text = this.getHeader();
        for (int i = 0; i < this.testDataset.numItemsets(); ++i) {
            try {
                int cl = this.evaluateItemset(this.testDataset.itemset(i), this.root);
                Itemset itemset = this.testDataset.itemset(i);
                if (cl == (int)itemset.getValue(this.testDataset.getClassIndex())) {
                    ++this.testCorrect;
                }
                text = text + this.testDataset.getClassAttribute().value((int)itemset.getClassValue()) + " " + this.testDataset.getClassAttribute().value(cl) + "\n";
                continue;
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
        try {
            PrintWriter print = new PrintWriter(new FileWriter(testOutputFileName));
            print.print(text);
            print.close();
        }
        catch (IOException e) {
            System.err.println("Can not open the training output file.");
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("\nError: you have to specify the parameters file\n\tusage: java -jar ART.jar parameterfile.txt");
            System.exit(-1);
        } else {
            ART aRT = new ART(args[0]);
        }
    }
}

