/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.HYB;

import java.util.Arrays;
import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerator;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.utilities.Debug;
import org.libsvm.svm;
import org.libsvm.svm_model;
import org.libsvm.svm_node;
import org.libsvm.svm_parameter;
import org.libsvm.svm_problem;

public class SVMSEL
extends PrototypeGenerator {
    private String kernelType;
    private int k = ((Prototype)this.trainingDataSet.get(0)).numberOfInputs();
    private double C = 1.0;
    private double eps = 0.1;
    private int degree = 3;
    private double gamma;
    private double nu = 0.5;
    private double p;
    private int shrinking;

    public SVMSEL(PrototypeSet _trainingDataSet, String kernelType, double C, double eps, int degree, double gamma, double nu, double p, int shrinking) {
        super(_trainingDataSet);
        this.kernelType = kernelType;
        this.C = C;
        this.eps = eps;
        this.degree = degree;
        this.gamma = gamma;
        this.nu = nu;
        this.p = p;
        this.shrinking = shrinking;
    }

    public SVMSEL(PrototypeSet _trainingDataSet, String kernelType) {
        super(_trainingDataSet);
        this.kernelType = kernelType;
        this.C = 1.0;
        this.eps = 0.1;
        this.degree = 3;
        this.gamma = 1.0 / (double)this.k;
        this.nu = 0.5;
        this.p = 0.1;
        this.shrinking = 1;
    }

    public PrototypeSet doSVMSelection() {
        int j;
        int i;
        PrototypeSet T = this.trainingDataSet.copy();
        int Tsize = T.size();
        int protSize = this.k;
        svm_parameter SVMparam = new svm_parameter();
        svm_problem SVMp = null;
        svm_model svr = null;
        SVMparam.C = this.C;
        SVMparam.cache_size = 20.0;
        SVMparam.degree = this.degree;
        SVMparam.eps = this.eps;
        SVMparam.gamma = this.gamma;
        SVMparam.nr_weight = 0;
        SVMparam.nu = this.nu;
        SVMparam.p = this.p;
        SVMparam.shrinking = this.shrinking;
        SVMparam.probability = 0;
        if (this.kernelType.compareTo("LINEAR") == 0) {
            SVMparam.kernel_type = 0;
        } else if (this.kernelType.compareTo("POLY") == 0) {
            SVMparam.kernel_type = 1;
        } else if (this.kernelType.compareTo("RBF") == 0) {
            SVMparam.kernel_type = 2;
        } else if (this.kernelType.compareTo("SIGMOID") == 0) {
            SVMparam.kernel_type = 3;
        }
        SVMparam.svm_type = 0;
        SVMp = new svm_problem();
        SVMp.l = Tsize;
        SVMp.y = new double[SVMp.l];
        SVMp.x = new svm_node[SVMp.l][protSize + 1];
        for (i = 0; i < SVMp.l; ++i) {
            for (j = 0; j < protSize + 1; ++j) {
                SVMp.x[i][j] = new svm_node();
            }
        }
        for (i = 0; i < Tsize; ++i) {
            SVMp.y[i] = ((Prototype)T.get(i)).label();
            for (j = 0; j < protSize; ++j) {
                SVMp.x[i][j].index = j;
                SVMp.x[i][j].value = ((Prototype)T.get(i)).getInput(j);
            }
            SVMp.x[i][protSize].index = -1;
        }
        if (svm.svm_check_parameter((svm_problem)SVMp, (svm_parameter)SVMparam) != null) {
            Debug.errorln("SVM parameter error in training: ");
            Debug.errorln(svm.svm_check_parameter((svm_problem)SVMp, (svm_parameter)SVMparam));
            Debug.goout("Error in SVM parameters");
        }
        svr = svm.svm_train((svm_problem)SVMp, (svm_parameter)SVMparam);
        double[] exTmp = new double[protSize];
        boolean[] marcas = new boolean[Tsize];
        Arrays.fill(marcas, false);
        int nSel = 0;
        for (int i2 = 0; i2 < svr.getSV().length; ++i2) {
            for (int j2 = 0; j2 < svr.getSV()[i2].length - 1; ++j2) {
                exTmp[j2] = svr.getSV()[i2][j2].value;
            }
            boolean coincide = false;
            for (int j3 = 0; j3 < Tsize && !coincide; ++j3) {
                boolean igual = true;
                for (int l = 0; l < protSize && igual; ++l) {
                    igual = exTmp[l] == ((Prototype)T.get(j3)).getInput(l);
                }
                if (!igual) continue;
                marcas[j3] = true;
                ++nSel;
                coincide = true;
            }
        }
        PrototypeSet S = new PrototypeSet(nSel);
        for (int i3 = 0; i3 < Tsize; ++i3) {
            if (!marcas[i3]) continue;
            S.add(T.get(i3));
        }
        return S;
    }

    @Override
    public PrototypeSet reduceSet() {
        return this.doSVMSelection();
    }
}

