/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.Chen;

import java.util.ArrayList;
import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerator;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.utilities.Distance;
import keel.Algorithms.Instance_Generation.utilities.KNN.KNN;
import keel.Algorithms.Instance_Generation.utilities.Pair;
import keel.Algorithms.Instance_Generation.utilities.Parameters;

public class ChenGenerator
extends PrototypeGenerator {
    protected int numberOfPrototypes;

    public ChenGenerator(PrototypeSet t, int n_d) {
        super(t);
        this.algorithmName = "Chen";
        this.numberOfPrototypes = n_d;
    }

    public ChenGenerator(PrototypeSet t, double percSet) {
        super(t);
        this.algorithmName = "Chen";
        this.numberOfPrototypes = this.getSetSizeFromPercentage(percSet);
    }

    public ChenGenerator(PrototypeSet t, Parameters params) {
        super(t, params);
        this.algorithmName = "Chen";
        this.numberOfPrototypes = this.getSetSizeFromPercentage(params.getNextAsDouble());
    }

    @Override
    public PrototypeSet reduceSet() {
        PrototypeSet D = this.trainingDataSet.clone();
        for (int i = 0; i < D.size(); ++i) {
            ((Prototype)D.get(i)).setIndex(i);
        }
        int Np = this.numberOfPrototypes;
        ArrayList<PrototypeSet> C = new ArrayList<PrototypeSet>(Np);
        Prototype P1 = null;
        Prototype P2 = null;
        System.err.println("Le he dicho tama\u00c3\u00b1o " + Np);
        for (int Nc = 0; Nc < Np; ++Nc) {
            Pair<Prototype, Prototype> Pi = D.farthestPrototypes();
            P1 = Pi.first();
            P2 = Pi.second();
            Pair<PrototypeSet, PrototypeSet> Di = D.partIntoSubsetsWhichSeedPointsAre(P1, P2);
            PrototypeSet D1 = Di.first();
            PrototypeSet D2 = Di.second();
            C.remove(D);
            C.add(D1);
            C.add(D2);
            ArrayList<PrototypeSet> I = null;
            ArrayList<PrototypeSet> I1 = new ArrayList<PrototypeSet>();
            ArrayList<PrototypeSet> I2 = new ArrayList<PrototypeSet>();
            for (PrototypeSet pSet : C) {
                if (pSet.containsSeveralClasses()) {
                    I1.add(pSet);
                    continue;
                }
                I2.add(pSet);
            }
            I = I1;
            if (I1.isEmpty()) {
                I = I2;
            }
            double distMax = -1.0;
            PrototypeSet Qchosen = (PrototypeSet)I.get(0);
            Pair<Prototype, Prototype> diameterPoints = null;
            for (PrototypeSet q : I) {
                Pair<Prototype, Prototype> farthest;
                double curDist;
                if (q.size() <= 1 || !(distMax < (curDist = Distance.d((farthest = q.farthestPrototypes()).first().formatear(), farthest.second().formatear())))) continue;
                distMax = curDist;
                Qchosen = q;
                diameterPoints = farthest;
            }
            D = Qchosen;
            P1 = (Prototype)diameterPoints.first();
            P2 = (Prototype)diameterPoints.second();
        }
        PrototypeSet result = new PrototypeSet(Np);
        for (int i = 0; i < Np; ++i) {
            Prototype averaged = ((PrototypeSet)C.get(i)).avg();
            double averagedClass = ((PrototypeSet)C.get(i)).mostFrequentClass();
            averaged.setLabel(averagedClass);
            result.add(averaged.formatear());
        }
        return result;
    }

    public static void main(String[] args) {
        Parameters.setUse("Chen", "<seed> <percentage of prototypes>");
        Parameters.assertBasicArgs(args);
        PrototypeSet training = PrototypeGenerationAlgorithm.readPrototypeSet(args[0]);
        PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(args[1]);
        long seed = Parameters.assertExtendedArgAsInt(args, 2, "seed", 0.0, 9.223372036854776E18);
        double percSize = Parameters.assertExtendedArgAsDouble(args, 3, "reduction size respect training size", 0.0, 100.0);
        ChenGenerator.setSeed(seed);
        ChenGenerator generator = new ChenGenerator(training, percSize);
        PrototypeSet resultingSet = generator.execute();
        int accuracy1NN = KNN.classficationAccuracy(resultingSet, test);
        generator.showResultsOfAccuracy(Parameters.getFileName(), accuracy1NN, test);
    }
}

