/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA;

import java.util.Enumeration;
import java.util.Vector;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.Antd;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.AttributeWeka;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.Classifier;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.FastVector;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.Instance;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.Instances;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.NumericAntd;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.RipperRule;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.Rule;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.RuleStats;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.Utils;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.WeightedInstancesHandler;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.parseParameters;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.InstanceSet;
import org.core.Files;
import org.core.Randomize;

public class FURIA
extends Classifier
implements WeightedInstancesHandler {
    static final long serialVersionUID = -6589312996832147161L;
    private static double MAX_DL_SURPLUS = 64.0;
    protected AttributeWeka m_Class;
    public FastVector m_Ruleset;
    protected FastVector m_Distributions;
    private int m_Optimizations;
    protected Randomize m_Random = null;
    protected double m_Total = 0.0;
    protected long m_Seed;
    private int m_Folds;
    double m_MinNo = 2.0;
    protected boolean m_Debug = false;
    private boolean m_CheckErr = true;
    double[] aprioriDistribution;
    protected FastVector m_RulesetStats;
    private boolean m_useRuleStretching = true;
    private String trainFile;
    private String evalFile;
    private String testFile;
    private String outputTrainFile;
    private String outputTestFile;
    private String outputClassifierFile;
    public static final int FILTER_NORMALIZE = 0;
    public static final int FILTER_STANDARDIZE = 1;
    public static final int FILTER_NONE = 2;

    public FURIA(parseParameters params) {
        this.m_Seed = Long.parseLong(params.getParameter(0));
        this.m_Optimizations = Integer.parseInt(params.getParameter(1));
        this.m_Folds = Integer.parseInt(params.getParameter(2));
        this.trainFile = params.getTrainingInputFile();
        this.evalFile = params.getValidationInputFile();
        this.testFile = params.getTestInputFile();
        this.outputTrainFile = params.getTrainingOutputFile();
        this.outputTestFile = params.getTestOutputFile();
        this.outputClassifierFile = params.getOutputFile(0);
    }

    public void execute() {
        InstanceSet IS = new InstanceSet();
        InstanceSet ISval = new InstanceSet();
        InstanceSet IStest = new InstanceSet();
        try {
            Instance instWeka;
            IS.readSet(this.trainFile, true);
            Instances isWeka = this.InstancesKEEL2Weka(IS, 2);
            this.buildClassifier(isWeka);
            ISval.readSet(this.evalFile, false);
            isWeka = this.InstancesKEEL2Weka(ISval, 2);
            Attribute a = Attributes.getOutputAttribute(0);
            String outputVal = new String("");
            int hits = 0;
            for (int i = 0; i < isWeka.numInstances(); ++i) {
                keel.Dataset.Instance inst = ISval.getInstance(i);
                instWeka = isWeka.instance(i);
                instWeka.setDataset(isWeka);
                int outputClass = (int)this.classifyInstance(instWeka);
                String realClass = inst.getOutputNominalValues(0);
                String predictedClass = a.getNominalValue(outputClass);
                if (realClass.compareTo(predictedClass) == 0) {
                    ++hits;
                }
                outputVal = outputVal + realClass + " " + predictedClass + "\n";
            }
            double accTrain = 1.0 * (double)hits / (double)isWeka.numInstances();
            IStest.readSet(this.testFile, false);
            isWeka = this.InstancesKEEL2Weka(IStest, 2);
            String outputTest = new String("");
            hits = 0;
            for (int i = 0; i < isWeka.numInstances(); ++i) {
                keel.Dataset.Instance inst = IStest.getInstance(i);
                instWeka = isWeka.instance(i);
                instWeka.setDataset(isWeka);
                int outputClass = (int)this.classifyInstance(instWeka);
                String realClass = inst.getOutputNominalValues(0);
                String predictedClass = a.getNominalValue(outputClass);
                if (realClass.compareTo(predictedClass) == 0) {
                    ++hits;
                }
                outputTest = outputTest + realClass + " " + predictedClass + "\n";
            }
            double accTest = 1.0 * (double)hits / (double)isWeka.numInstances();
            this.writeOutput(outputVal, outputTest, accTrain, accTest);
        }
        catch (Exception ex) {
            System.err.println("Fatal Error building the FURIA model!");
            ex.printStackTrace();
        }
        Files.writeFile(this.outputClassifierFile, this.toString() + "\n\n\n\n" + "REGLAS = " + this.m_Ruleset.size());
    }

    protected Instances InstancesKEEL2Weka(InstanceSet is, int preprocessType) {
        Attribute a;
        int i;
        int out = Attributes.getInputNumAttributes();
        FastVector atts = new FastVector(Attributes.getNumAttributes());
        for (i = 0; i < Attributes.getNumAttributes(); ++i) {
            AttributeWeka aWeka;
            a = Attributes.getAttribute(i);
            if (a.getType() == 0) {
                FastVector nominalValues = new FastVector(a.getNumNominalValues());
                for (int j = 0; j < a.getNumNominalValues(); ++j) {
                    nominalValues.addElement(a.getNominalValue(j));
                }
                aWeka = new AttributeWeka(a.getName(), nominalValues, i);
            } else {
                String range = new String("[");
                range = range + a.getMinAttribute();
                range = range + ",";
                range = range + a.getMaxAttribute();
                range = range + ")";
                aWeka = new AttributeWeka(a.getName(), i);
                aWeka.setNumericRange(range);
            }
            atts.addElement(aWeka);
            if (a.getDirectionAttribute() != 2) continue;
            out = i;
        }
        Instances data = new Instances(Attributes.getRelationName(), atts, is.getNumInstances());
        data.setClassIndex(out);
        int newNumAttributes = Attributes.getNumAttributes();
        for (i = 0; i < is.getNumInstances(); ++i) {
            keel.Dataset.Instance instK = is.getInstance(i);
            out = 0;
            int in = 0;
            int enlargedValueVectorPos = 0;
            double[] values = new double[newNumAttributes];
            for (int j = 0; j < Attributes.getNumAttributes(); ++j) {
                a = Attributes.getAttribute(j);
                if (a.getDirectionAttribute() == 1) {
                    if (a.getType() != 0) {
                        values[enlargedValueVectorPos] = instK.getAllInputValues()[in];
                        ++enlargedValueVectorPos;
                    } else {
                        values[enlargedValueVectorPos] = instK.getAllInputValues()[in];
                        ++enlargedValueVectorPos;
                    }
                    ++in;
                    continue;
                }
                values[enlargedValueVectorPos] = instK.getAllOutputValues()[out];
                ++out;
                ++enlargedValueVectorPos;
            }
            Instance instW = new Instance(1.0, values);
            data.add(instW);
        }
        return data;
    }

    void writeOutput(String outputVal, String outputTest, double accTrain, double accTest) {
        String p = new String("");
        p = "@relation " + Attributes.getRelationName() + "\n";
        p = p + Attributes.getInputAttributesHeader();
        p = p + Attributes.getOutputAttributesHeader();
        p = p + Attributes.getInputHeader() + "\n";
        p = p + Attributes.getOutputHeader() + "\n";
        p = p + "@data\n";
        Files.writeFile(this.outputTrainFile, p + outputVal);
        Files.writeFile(this.outputTestFile, p + outputTest);
        System.out.println("Training accuracy: " + accTrain);
        System.out.println("Test accuracy: " + accTest);
        System.out.println("m_Optimizations = " + this.m_Optimizations);
        System.out.println("m_Seed = " + this.m_Seed);
        System.out.println("m_Folds = " + this.m_Folds);
        System.out.println("m_MinNo = " + this.m_MinNo);
    }

    public Enumeration enumerateMeasures() {
        Vector<String> newVector = new Vector<String>(1);
        newVector.addElement("measureNumRules");
        return newVector.elements();
    }

    public double getMeasure(String additionalMeasureName) {
        if (additionalMeasureName.compareToIgnoreCase("measureNumRules") == 0) {
            return this.m_Ruleset.size();
        }
        throw new IllegalArgumentException(additionalMeasureName + " not supported (RIPPER)");
    }

    public String foldsTipText() {
        return "Determines the amount of data used for pruning. One fold is used for pruning, the rest for growing the rules.";
    }

    public void setFolds(int fold) {
        this.m_Folds = fold;
    }

    public int getFolds() {
        return this.m_Folds;
    }

    public String minNoTipText() {
        return "The minimum total weight of the instances in a rule.";
    }

    public void setMinNo(double m) {
        this.m_MinNo = m;
    }

    public double getMinNo() {
        return this.m_MinNo;
    }

    public String seedTipText() {
        return "The seed used for randomizing the data.";
    }

    public void setSeed(long s) {
        this.m_Seed = s;
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public String optimizationsTipText() {
        return "The number of optimization runs.";
    }

    public void setOptimizations(int run) {
        this.m_Optimizations = run;
    }

    public int getOptimizations() {
        return this.m_Optimizations;
    }

    @Override
    public String debugTipText() {
        return "Whether debug information is output to the console.";
    }

    @Override
    public void setDebug(boolean d) {
        this.m_Debug = d;
    }

    @Override
    public boolean getDebug() {
        return this.m_Debug;
    }

    public String checkErrorRateTipText() {
        return "Whether check for error rate >= 1/2 is included in stopping criterion.";
    }

    public void setCheckErrorRate(boolean d) {
        this.m_CheckErr = d;
    }

    public boolean getCheckErrorRate() {
        return this.m_CheckErr;
    }

    public String useRuleStretchingTipText() {
        return "Whether rule stretching is performed.";
    }

    public void setUseRuleStretching(boolean d) {
        this.m_useRuleStretching = d;
    }

    public boolean getUseRuleStretching() {
        return this.m_useRuleStretching;
    }

    public FastVector getRuleset() {
        return this.m_Ruleset;
    }

    public RuleStats getRuleStats(int pos) {
        return (RuleStats)this.m_RulesetStats.elementAt(pos);
    }

    @Override
    public void buildClassifier(Instances instances) throws Exception {
        int j;
        int z;
        Instances data;
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.aprioriDistribution = new double[instances.classAttribute().numValues()];
        boolean allWeightsAreOne = true;
        for (int i = 0; i < instances.numInstances(); ++i) {
            int n = (int)instances.instance(i).classValue();
            this.aprioriDistribution[n] = this.aprioriDistribution[n] + instances.instance(i).weight();
            if (!allWeightsAreOne || instances.instance(i).weight() == 1.0) continue;
            allWeightsAreOne = false;
            break;
        }
        Randomize.setSeed(this.m_Seed);
        this.m_Total = RuleStats.numAllConditions(instances);
        if (this.m_Debug) {
            System.err.println("Number of all possible conditions = " + this.m_Total);
        }
        if ((data = new Instances(instances)) == null) {
            throw new Exception(" Unable to randomize the class orders.");
        }
        this.m_Class = data.classAttribute();
        this.m_Ruleset = new FastVector();
        this.m_RulesetStats = new FastVector();
        this.m_Distributions = new FastVector();
        if (this.m_Debug) {
            System.err.println("Sorted classes:");
            for (int x = 0; x < this.m_Class.numValues(); ++x) {
                System.err.println(x + ": " + this.m_Class.value(x) + " has " + this.aprioriDistribution[x] + " instances.");
            }
        }
        for (int y = 0; y < data.numClasses(); ++y) {
            double classIndex = y;
            if (this.m_Debug) {
                int ci = (int)classIndex;
                System.err.println("\n\nClass " + this.m_Class.value(ci) + "(" + ci + "): " + this.aprioriDistribution[y] + "instances\n" + "=====================================\n");
            }
            if (Utils.eq(this.aprioriDistribution[y], 0.0)) continue;
            double expFPRate = this.aprioriDistribution[y] / Utils.sum(this.aprioriDistribution);
            double classYWeights = 0.0;
            double totalWeights = 0.0;
            for (int j2 = 0; j2 < data.numInstances(); ++j2) {
                Instance datum = data.instance(j2);
                totalWeights += datum.weight();
                if ((int)datum.classValue() != y) continue;
                classYWeights += datum.weight();
            }
            if (!(classYWeights > 0.0)) continue;
            double defDL = RuleStats.dataDL(expFPRate, 0.0, totalWeights, 0.0, classYWeights);
            if (Double.isNaN(defDL) || Double.isInfinite(defDL)) {
                throw new Exception("Should never happen: defDL NaN or infinite!");
            }
            if (this.m_Debug) {
                System.err.println("The default DL = " + defDL);
            }
            this.rulesetForOneClass(expFPRate, data, classIndex, defDL);
        }
        for (z = 0; z < this.m_Ruleset.size(); ++z) {
            RipperRule rule = (RipperRule)this.m_Ruleset.elementAt(z);
            for (j = 0; j < rule.m_Antds.size(); ++j) {
                Antd outerAntd = (Antd)rule.m_Antds.elementAt(j);
                for (int k = j + 1; k < rule.m_Antds.size(); ++k) {
                    Antd innerAntd = (Antd)rule.m_Antds.elementAt(k);
                    if (outerAntd.att.index() != innerAntd.att.index() || outerAntd.value != innerAntd.value) continue;
                    rule.m_Antds.setElementAt(rule.m_Antds.elementAt(k), j);
                    rule.m_Antds.removeElementAt(k--);
                }
            }
        }
        for (z = 0; z < this.m_RulesetStats.size(); ++z) {
            RuleStats oneClass = (RuleStats)this.m_RulesetStats.elementAt(z);
            for (int xyz = 0; xyz < oneClass.getRulesetSize(); ++xyz) {
                RipperRule rule = (RipperRule)oneClass.getRuleset().elementAt(xyz);
                rule.findAndSetSupportBoundForKnownAntecedents(data, allWeightsAreOne);
                double[] classDist = oneClass.getDistributions(xyz);
                if (Utils.sum(classDist) > 0.0) {
                    Utils.normalize(classDist);
                }
                if (classDist == null) continue;
                this.m_Distributions.addElement(classDist);
            }
        }
        for (z = 0; z < this.m_Ruleset.size(); ++z) {
            RipperRule rule = (RipperRule)this.m_Ruleset.elementAt(z);
            for (j = 0; j < rule.m_Antds.size(); ++j) {
                Antd antd = (Antd)rule.m_Antds.elementAt(j);
                if (!(antd instanceof NumericAntd)) continue;
                NumericAntd numAntd = (NumericAntd)antd;
                if (numAntd.fuzzyYet) continue;
                for (int i = 0; i < data.numInstances(); ++i) {
                    if ((numAntd.value != 1.0 || !(numAntd.splitPoint > data.instance(i).value(numAntd.att.index())) || !(numAntd.supportBound < data.instance(i).value(numAntd.att.index())) && numAntd.fuzzyYet) && (numAntd.value != 0.0 || !(numAntd.splitPoint < data.instance(i).value(numAntd.att.index())) || !(numAntd.supportBound > data.instance(i).value(numAntd.att.index())) && numAntd.fuzzyYet)) continue;
                    numAntd.supportBound = data.instance(i).value(numAntd.att.index());
                    numAntd.fuzzyYet = true;
                }
            }
        }
        for (z = 0; z < this.m_Ruleset.size(); ++z) {
            RipperRule rule = (RipperRule)this.m_Ruleset.elementAt(z);
            rule.calculateConfidences(data);
        }
    }

    @Override
    public double[] distributionForInstance(Instance datum) throws Exception {
        int i;
        double[] rulesCoveringForEachClass = new double[datum.numClasses()];
        for (int i2 = 0; i2 < this.m_Ruleset.size(); ++i2) {
            RipperRule rule = (RipperRule)this.m_Ruleset.elementAt(i2);
            if (!rule.hasAntds() || !rule.covers(datum)) continue;
            int n = (int)rule.m_Consequent;
            rulesCoveringForEachClass[n] = rulesCoveringForEachClass[n] + rule.coverageDegree(datum) * rule.getConfidence();
        }
        if (Utils.sum(rulesCoveringForEachClass) == 0.0) {
            if (!this.m_useRuleStretching) {
                return new double[rulesCoveringForEachClass.length];
            }
            FastVector origRuleset = (FastVector)this.m_Ruleset.copyElements();
            double maxConfidence = Double.NEGATIVE_INFINITY;
            for (int i3 = 0; i3 < this.m_Ruleset.size(); ++i3) {
                int j;
                RipperRule rule = (RipperRule)this.m_Ruleset.elementAt(i3);
                double numAntdsBefore = rule.m_Antds.size();
                int firstAntdToDelete = Integer.MAX_VALUE;
                for (j = 0; j < rule.m_Antds.size(); ++j) {
                    if (((Antd)rule.m_Antds.elementAt(j)).covers(datum) != 0.0) continue;
                    firstAntdToDelete = j;
                    break;
                }
                for (j = firstAntdToDelete; j < rule.m_Antds.size(); ++j) {
                    rule.m_Antds.removeElementAt(j--);
                }
                double numAntdsAfter = rule.m_Antds.size();
                if (!rule.hasAntds()) continue;
                double secondWeight = (numAntdsAfter + 1.0) / (numAntdsBefore + 2.0);
                if (!(rule.getConfidence() * secondWeight * rule.coverageDegree(datum) >= maxConfidence)) continue;
                maxConfidence = rule.getConfidence() * secondWeight * rule.coverageDegree(datum);
                rulesCoveringForEachClass = new double[rulesCoveringForEachClass.length];
                rulesCoveringForEachClass[(int)rule.m_Consequent] = 1.0;
            }
            this.m_Ruleset = origRuleset;
        }
        double[] maxClasses = new double[rulesCoveringForEachClass.length];
        for (i = 0; i < rulesCoveringForEachClass.length; ++i) {
            if (rulesCoveringForEachClass[Utils.maxIndex(rulesCoveringForEachClass)] != rulesCoveringForEachClass[i] || !(rulesCoveringForEachClass[i] > 0.0)) continue;
            maxClasses[i] = 1.0;
        }
        if (Utils.sum(maxClasses) > 0.0) {
            for (i = 0; i < maxClasses.length; ++i) {
                int n = i;
                maxClasses[n] = maxClasses[n] * (this.aprioriDistribution[i] / Utils.sum(this.aprioriDistribution));
            }
            rulesCoveringForEachClass = maxClasses;
        }
        if (Utils.sum(rulesCoveringForEachClass) == 0.0) {
            rulesCoveringForEachClass = this.aprioriDistribution;
        }
        if (Utils.sum(rulesCoveringForEachClass) > 0.0) {
            Utils.normalize(rulesCoveringForEachClass);
        }
        return rulesCoveringForEachClass;
    }

    protected Instances rulesetForOneClass(double expFPRate, Instances data, double classIndex, double defDL) throws Exception {
        double[] rst;
        boolean defHasPositive;
        Instances newData = data;
        boolean stop = false;
        FastVector ruleset = new FastVector();
        double dl = defDL;
        double minDL = defDL;
        RuleStats rstats = null;
        boolean hasPositive = defHasPositive = true;
        if (this.m_Debug) {
            System.err.println("\n*** Building stage ***");
        }
        while (!stop && hasPositive) {
            RipperRule oneRule = new RipperRule(this.aprioriDistribution);
            oneRule.setConsequent(classIndex);
            if (this.m_Debug) {
                System.err.println("\nNo pruning: growing a rule ...");
            }
            oneRule.grow(newData);
            if (this.m_Debug) {
                System.err.println("No pruning: one rule found:\n" + oneRule.toString(this.m_Class));
            }
            if (rstats == null) {
                rstats = new RuleStats();
                rstats.setNumAllConds(this.m_Total);
                rstats.setData(newData);
            }
            rstats.addAndUpdate(oneRule);
            int last = rstats.getRuleset().size() - 1;
            if (Double.isNaN(dl += rstats.relativeDL(last, expFPRate, this.m_CheckErr)) || Double.isInfinite(dl)) {
                throw new Exception("Should never happen: dl in building stage NaN or infinite!");
            }
            if (this.m_Debug) {
                System.err.println("Before optimization(" + last + "): the dl = " + dl + " | best: " + minDL);
            }
            if (dl < minDL) {
                minDL = dl;
            }
            rst = rstats.getSimpleStats(last);
            if (this.m_Debug) {
                System.err.println("The rule covers: " + rst[0] + " | pos = " + rst[2] + " | neg = " + rst[4] + "\nThe rule doesn't cover: " + rst[1] + " | pos = " + rst[5]);
            }
            if (!(stop = this.checkStop(rst, minDL, dl))) {
                ruleset.addElement(oneRule);
                newData = rstats.getFiltered(last)[1];
                hasPositive = Utils.gr(rst[5], 0.0);
                if (!this.m_Debug) continue;
                System.err.println("One rule added: has positive? " + hasPositive);
                continue;
            }
            if (this.m_Debug) {
                System.err.println("Quit rule");
            }
            rstats.removeLast();
        }
        RuleStats finalRulesetStat = null;
        for (int z = 0; z < this.m_Optimizations; ++z) {
            if (this.m_Debug) {
                System.err.println("\n*** Optimization: run #" + z + " ***");
            }
            newData = data;
            finalRulesetStat = new RuleStats();
            finalRulesetStat.setData(newData);
            finalRulesetStat.setNumAllConds(this.m_Total);
            int position = 0;
            stop = false;
            boolean isResidual = false;
            hasPositive = defHasPositive;
            dl = minDL = defDL;
            while (!stop && hasPositive) {
                RipperRule finalRule;
                isResidual = position >= ruleset.size();
                newData = RuleStats.stratify(newData, this.m_Folds, this.m_Random);
                Instances[] part = RuleStats.partition(newData, this.m_Folds);
                Instances growData = part[0];
                Instances pruneData = part[1];
                if (this.m_Debug) {
                    System.err.println("\nRule #" + position + "| isResidual?" + isResidual + "| data size: " + newData.sumOfWeights());
                }
                if (isResidual) {
                    RipperRule newRule = new RipperRule(this.aprioriDistribution);
                    newRule.setConsequent(classIndex);
                    if (this.m_Debug) {
                        System.err.println("\nGrowing and pruning a new rule ...");
                    }
                    newRule.grow(newData);
                    finalRule = newRule;
                    if (this.m_Debug) {
                        System.err.println("\nNew rule found: " + newRule.toString(this.m_Class));
                    }
                } else {
                    RipperRule oldRule = (RipperRule)ruleset.elementAt(position);
                    boolean covers = false;
                    for (int i = 0; i < newData.numInstances(); ++i) {
                        if (!oldRule.covers(newData.instance(i))) continue;
                        covers = true;
                        break;
                    }
                    if (!covers) {
                        finalRulesetStat.addAndUpdate(oldRule);
                        ++position;
                        continue;
                    }
                    if (this.m_Debug) {
                        System.err.println("\nGrowing and pruning Replace ...");
                    }
                    RipperRule replace = new RipperRule(this.aprioriDistribution);
                    replace.setConsequent(classIndex);
                    replace.grow(growData);
                    pruneData = RuleStats.rmCoveredBySuccessives(pruneData, ruleset, position);
                    replace.prune(pruneData, true);
                    if (this.m_Debug) {
                        System.err.println("\nGrowing and pruning Revision ...");
                    }
                    RipperRule revision = (RipperRule)oldRule.copy();
                    Instances newGrowData = new Instances(growData, 0);
                    for (int b = 0; b < growData.numInstances(); ++b) {
                        Instance inst = growData.instance(b);
                        if (!revision.covers(inst)) continue;
                        newGrowData.add(inst);
                    }
                    revision.grow(newGrowData);
                    revision.prune(pruneData, true);
                    double[][] prevRuleStats = new double[position][6];
                    for (int c = 0; c < position; ++c) {
                        prevRuleStats[c] = finalRulesetStat.getSimpleStats(c);
                    }
                    FastVector tempRules = (FastVector)ruleset.copyElements();
                    tempRules.setElementAt(replace, position);
                    RuleStats repStat = new RuleStats(data, tempRules);
                    repStat.setNumAllConds(this.m_Total);
                    repStat.countData(position, newData, prevRuleStats);
                    rst = repStat.getSimpleStats(position);
                    if (this.m_Debug) {
                        System.err.println("Replace rule covers: " + rst[0] + " | pos = " + rst[2] + " | neg = " + rst[4] + "\nThe rule doesn't cover: " + rst[1] + " | pos = " + rst[5]);
                    }
                    double repDL = repStat.relativeDL(position, expFPRate, this.m_CheckErr);
                    if (this.m_Debug) {
                        System.err.println("\nReplace: " + replace.toString(this.m_Class) + " |dl = " + repDL);
                    }
                    if (Double.isNaN(repDL) || Double.isInfinite(repDL)) {
                        throw new Exception("Should never happen: repDLin optmz. stage NaN or infinite!");
                    }
                    tempRules.setElementAt(revision, position);
                    RuleStats revStat = new RuleStats(data, tempRules);
                    revStat.setNumAllConds(this.m_Total);
                    revStat.countData(position, newData, prevRuleStats);
                    double revDL = revStat.relativeDL(position, expFPRate, this.m_CheckErr);
                    if (this.m_Debug) {
                        System.err.println("Revision: " + revision.toString(this.m_Class) + " |dl = " + revDL);
                    }
                    if (Double.isNaN(revDL) || Double.isInfinite(revDL)) {
                        throw new Exception("Should never happen: revDLin optmz. stage NaN or infinite!");
                    }
                    rstats = new RuleStats(data, ruleset);
                    rstats.setNumAllConds(this.m_Total);
                    rstats.countData(position, newData, prevRuleStats);
                    double oldDL = rstats.relativeDL(position, expFPRate, this.m_CheckErr);
                    if (Double.isNaN(oldDL) || Double.isInfinite(oldDL)) {
                        throw new Exception("Should never happen: oldDLin optmz. stage NaN or infinite!");
                    }
                    if (this.m_Debug) {
                        System.err.println("Old rule: " + oldRule.toString(this.m_Class) + " |dl = " + oldDL);
                    }
                    if (this.m_Debug) {
                        System.err.println("\nrepDL: " + repDL + "\nrevDL: " + revDL + "\noldDL: " + oldDL);
                    }
                    finalRule = oldDL <= revDL && oldDL <= repDL ? oldRule : (revDL <= repDL ? revision : replace);
                }
                finalRulesetStat.addAndUpdate(finalRule);
                rst = finalRulesetStat.getSimpleStats(position);
                if (isResidual) {
                    dl += finalRulesetStat.relativeDL(position, expFPRate, this.m_CheckErr);
                    if (this.m_Debug) {
                        System.err.println("After optimization: the dl=" + dl + " | best: " + minDL);
                    }
                    if (dl < minDL) {
                        minDL = dl;
                    }
                    if (!(stop = this.checkStop(rst, minDL, dl))) {
                        ruleset.addElement(finalRule);
                    } else {
                        finalRulesetStat.removeLast();
                        --position;
                    }
                } else {
                    ruleset.setElementAt(finalRule, position);
                }
                if (this.m_Debug) {
                    System.err.println("The rule covers: " + rst[0] + " | pos = " + rst[2] + " | neg = " + rst[4] + "\nThe rule doesn't cover: " + rst[1] + " | pos = " + rst[5]);
                    System.err.println("\nRuleset so far: ");
                    for (int x = 0; x < ruleset.size(); ++x) {
                        System.err.println(x + ": " + ((RipperRule)ruleset.elementAt(x)).toString(this.m_Class));
                    }
                    System.err.println();
                }
                if (finalRulesetStat.getRulesetSize() > 0) {
                    newData = finalRulesetStat.getFiltered(position)[1];
                }
                hasPositive = Utils.gr(rst[5], 0.0);
                ++position;
            }
            if (ruleset.size() > position + 1) {
                for (int k = position + 1; k < ruleset.size(); ++k) {
                    finalRulesetStat.addAndUpdate((Rule)ruleset.elementAt(k));
                }
            }
            if (this.m_Debug) {
                System.err.println("\nDeleting rules to decrease DL of the whole ruleset ...");
            }
            finalRulesetStat.reduceDL(expFPRate, this.m_CheckErr);
            if (this.m_Debug) {
                int del = ruleset.size() - finalRulesetStat.getRulesetSize();
                System.err.println(del + " rules are deleted" + " after DL reduction procedure");
            }
            ruleset = finalRulesetStat.getRuleset();
            rstats = finalRulesetStat;
        }
        if (this.m_Debug) {
            System.err.println("\nFinal ruleset: ");
            for (int x = 0; x < ruleset.size(); ++x) {
                System.err.println(x + ": " + ((RipperRule)ruleset.elementAt(x)).toString(this.m_Class));
            }
            System.err.println();
        }
        this.m_Ruleset.appendElements(ruleset);
        this.m_RulesetStats.addElement(rstats);
        return null;
    }

    private boolean checkStop(double[] rst, double minDL, double dl) {
        if (dl > minDL + MAX_DL_SURPLUS) {
            if (this.m_Debug) {
                System.err.println("DL too large: " + dl + " | " + minDL);
            }
            return true;
        }
        if (!Utils.gr(rst[2], 0.0)) {
            if (this.m_Debug) {
                System.err.println("Too few positives.");
            }
            return true;
        }
        if (rst[4] / rst[0] >= 0.5) {
            if (this.m_CheckErr) {
                if (this.m_Debug) {
                    System.err.println("Error too large: " + rst[4] + "/" + rst[0]);
                }
                return true;
            }
            return false;
        }
        if (this.m_Debug) {
            System.err.println("Continue.");
        }
        return false;
    }

    public String toString() {
        if (this.m_Ruleset == null) {
            return "FURIA: No model built yet.";
        }
        StringBuffer sb = new StringBuffer("FURIA rules:\n===========\n\n");
        for (int j = 0; j < this.m_RulesetStats.size(); ++j) {
            RuleStats rs = (RuleStats)this.m_RulesetStats.elementAt(j);
            FastVector rules = rs.getRuleset();
            for (int k = 0; k < rules.size(); ++k) {
                sb.append(((RipperRule)rules.elementAt(k)).toString(this.m_Class) + " (CF = " + (double)Math.round(100.0 * ((RipperRule)rules.elementAt(k)).getConfidence()) / 100.0 + ")\n");
            }
        }
        sb.append("\n\n\nReglas Buenas\n");
        sb.append("Inside m_Ruleset\n");
        for (int i = 0; i < this.m_Ruleset.size(); ++i) {
            sb.append(((RipperRule)this.m_Ruleset.elementAt(i)).toString(this.m_Class) + " (CF = " + (double)Math.round(100.0 * ((RipperRule)this.m_Ruleset.elementAt(i)).getConfidence()) / 100.0 + ")\n");
        }
        sb.append("\nNumber of Rules : " + this.m_Ruleset.size() + "\n");
        return sb.toString();
    }

    public String getRevision() {
        return "1.0";
    }
}

