/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Algorithms;

import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Algorithms.GeneticAlgorithm;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Individual.GeneticIndividual;
import keel.Algorithms.Shared.Exceptions.invalidCrossover;
import keel.Algorithms.Shared.Exceptions.invalidFitness;
import keel.Algorithms.Shared.Exceptions.invalidMutation;
import keel.Algorithms.Shared.Exceptions.invalidOptim;
import org.core.Randomize;

public class GeneticAlgorithmSteady
extends GeneticAlgorithm {
    GeneticIndividual[][] population;
    int[] tournament;
    int[] tournament2;
    double[] tournamentFitness;
    double[][] fitnessCache;
    double MUTATIONPROB;
    double MUTATIONAMPL;
    double MIGRATIONPROB;
    double LOCALOPTPROB;
    int LOCALOPTITER;
    double[] fitnessMark;
    double[] bestFitness;
    static Randomize rand;
    int CROSSOVERID;
    int MUTATIONID;
    int LOID;

    public GeneticAlgorithmSteady(GeneticIndividual initialIndividual, int pPopSize, int pGenerations, int pTourSize, double PM, double AMP, double PMG, double pLOptProb, int NOL, int IOL, Randomize r, int pCrossoverID, int pMutationID) {
        rand = r;
        this.population = new GeneticIndividual[pGenerations][pPopSize];
        this.tournament = new int[pTourSize];
        this.tournament2 = new int[pTourSize];
        this.tournamentFitness = new double[pTourSize];
        this.fitnessCache = new double[pGenerations][pPopSize];
        this.fitnessMark = new double[pGenerations];
        this.bestFitness = new double[pGenerations];
        this.MUTATIONPROB = PM;
        this.MIGRATIONPROB = PMG;
        this.LOCALOPTPROB = pLOptProb;
        this.MUTATIONAMPL = AMP;
        this.CROSSOVERID = pCrossoverID;
        this.MUTATIONID = pMutationID;
        this.LOCALOPTITER = NOL;
        this.LOID = IOL;
        try {
            for (int p = 0; p < pGenerations; ++p) {
                this.fitnessMark[p] = 0.0;
                this.bestFitness[p] = 0.0;
                for (int i = 0; i < pPopSize; ++i) {
                    System.out.println("Inicialiting the population[" + i + "]");
                    this.population[p][i] = initialIndividual.clone();
                    this.population[p][i].Random();
                    this.fitnessCache[p][i] = this.population[p][i].fitness();
                    int n = p;
                    this.fitnessMark[n] = this.fitnessMark[n] + this.fitnessCache[p][i];
                    if (!(this.fitnessCache[p][i] < this.bestFitness[p]) && i != 0) continue;
                    this.bestFitness[p] = this.fitnessCache[p][i];
                }
            }
        }
        catch (invalidFitness e) {
            System.out.println("Unsupported fitness function");
        }
    }

    private void sortedInsertion(int x, double valueX, int[] tournament) {
        int pos;
        for (pos = 0; tournament[pos] >= 0 && valueX > this.tournamentFitness[pos] && pos < tournament.length; ++pos) {
        }
        if (pos == tournament.length) {
            return;
        }
        for (int i = tournament.length - 1; i > pos; --i) {
            tournament[i] = tournament[i - 1];
            this.tournamentFitness[i] = this.tournamentFitness[i - 1];
        }
        tournament[pos] = x;
        this.tournamentFitness[pos] = valueX;
    }

    @Override
    public GeneticIndividual evolve(int MAXITER) throws invalidCrossover, invalidMutation, invalidOptim {
        int pTourSize = this.tournament.length;
        System.out.println("Calculation " + MAXITER + " generations ");
        try {
            for (int i = 0; i < MAXITER; ++i) {
                if (i % 100 == 0) {
                    System.out.println("Generation=" + i);
                }
                for (int p = 0; p < this.population.length; ++p) {
                    int j;
                    for (j = 0; j < pTourSize; ++j) {
                        this.tournament[j] = -1;
                    }
                    for (j = 0; j < pTourSize; ++j) {
                        int ind = 0;
                        boolean hasBeenFound = false;
                        block6: do {
                            hasBeenFound = false;
                            ind = (int)(rand.Rand() * (double)this.population[p].length);
                            for (int k = 0; k < pTourSize; ++k) {
                                if (ind != this.tournament[k]) continue;
                                hasBeenFound = true;
                                continue block6;
                            }
                        } while (hasBeenFound);
                        this.sortedInsertion(ind, this.fitnessCache[p][ind], this.tournament);
                    }
                    this.population[p][this.tournament[0]].crossover(this.population[p][this.tournament[1]], this.population[p][this.tournament[pTourSize - 2]], this.population[p][this.tournament[pTourSize - 1]], this.CROSSOVERID);
                    if (rand.Rand() < this.MUTATIONPROB) {
                        this.population[p][this.tournament[pTourSize - 2]].mutation(this.MUTATIONAMPL, this.MUTATIONID);
                    }
                    if (rand.Rand() < this.MUTATIONPROB) {
                        this.population[p][this.tournament[pTourSize - 1]].mutation(this.MUTATIONAMPL, this.MUTATIONID);
                    }
                    if (rand.Rand() < this.LOCALOPTPROB) {
                        this.population[p][this.tournament[pTourSize - 2]].localOptimization(this.LOCALOPTITER, this.LOID);
                    }
                    if (rand.Rand() < this.LOCALOPTPROB) {
                        this.population[p][this.tournament[pTourSize - 1]].localOptimization(this.LOCALOPTITER, this.LOID);
                    }
                    if (rand.Rand() < this.MIGRATIONPROB) {
                        int j2;
                        int lTheOutput = (int)(rand.Rand() * (double)this.population.length);
                        for (j2 = 0; j2 < pTourSize; ++j2) {
                            this.tournament2[j2] = -1;
                        }
                        for (j2 = 0; j2 < pTourSize; ++j2) {
                            int ind = 0;
                            boolean hasBeenFound = false;
                            block10: do {
                                hasBeenFound = false;
                                ind = (int)(rand.Rand() * (double)this.population[lTheOutput].length);
                                for (int k = 0; k < pTourSize; ++k) {
                                    if (ind != this.tournament2[k]) continue;
                                    hasBeenFound = true;
                                    continue block10;
                                }
                            } while (hasBeenFound);
                            this.sortedInsertion(ind, this.fitnessCache[lTheOutput][ind], this.tournament2);
                        }
                        int n = lTheOutput;
                        this.fitnessMark[n] = this.fitnessMark[n] - this.fitnessCache[lTheOutput][this.tournament[pTourSize - 1]];
                        this.population[lTheOutput][this.tournament2[pTourSize - 1]] = this.population[p][this.tournament[0]].clone();
                        this.fitnessCache[lTheOutput][this.tournament2[pTourSize - 1]] = this.fitnessCache[p][this.tournament[0]];
                        int n2 = lTheOutput;
                        this.fitnessMark[n2] = this.fitnessMark[n2] + this.fitnessCache[lTheOutput][this.tournament[pTourSize - 1]];
                    }
                    int n = p;
                    this.fitnessMark[n] = this.fitnessMark[n] - this.fitnessCache[p][this.tournament[pTourSize - 2]];
                    int n3 = p;
                    this.fitnessMark[n3] = this.fitnessMark[n3] - this.fitnessCache[p][this.tournament[pTourSize - 1]];
                    this.fitnessCache[p][this.tournament[pTourSize - 2]] = this.population[p][this.tournament[pTourSize - 2]].fitness();
                    this.fitnessCache[p][this.tournament[pTourSize - 1]] = this.population[p][this.tournament[pTourSize - 1]].fitness();
                    int n4 = p;
                    this.fitnessMark[n4] = this.fitnessMark[n4] + this.fitnessCache[p][this.tournament[pTourSize - 2]];
                    int n5 = p;
                    this.fitnessMark[n5] = this.fitnessMark[n5] + this.fitnessCache[p][this.tournament[pTourSize - 1]];
                    if (this.fitnessCache[p][this.tournament[pTourSize - 2]] < this.bestFitness[p]) {
                        this.bestFitness[p] = this.fitnessCache[p][this.tournament[pTourSize - 2]];
                    }
                    if (this.fitnessCache[p][this.tournament[pTourSize - 1]] < this.bestFitness[p]) {
                        this.bestFitness[p] = this.fitnessCache[p][this.tournament[pTourSize - 1]];
                    }
                    if (i % 100 != 0) continue;
                    System.out.println("The best fitness=" + this.bestFitness[p] + " the fitness mean=" + this.fitnessMark[p] / (double)this.population[p].length);
                }
            }
        }
        catch (invalidFitness f) {
            System.out.println("Unsupported fitnes function");
        }
        int pmin = 0;
        double minfit = 0.0;
        int imin = 0;
        boolean theFirst = true;
        for (int p = 0; p < this.population.length; ++p) {
            for (int i = 0; i < this.population[p].length; ++i) {
                double fit = this.fitnessCache[p][i];
                if (!(fit < minfit) && !theFirst) continue;
                theFirst = false;
                minfit = fit;
                imin = i;
                pmin = p;
            }
        }
        System.out.println("Minimum Fitness found=" + minfit);
        return this.population[pmin][imin].clone();
    }
}

