/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Hyperrectangles.BNGE;

import java.util.StringTokenizer;
import keel.Algorithms.Hyperrectangles.BNGE.Rule;
import keel.Algorithms.Hyperrectangles.Basic.HyperrectanglesAlgorithm;
import keel.Dataset.Attributes;
import org.core.Fichero;
import org.core.Randomize;

public class BNGE
extends HyperrectanglesAlgorithm {
    Rule[] ruleset;

    public BNGE(String script) {
        this.readDataFiles(script);
        this.name = "BNGE";
        Rule.setSize(this.inputAtt);
        Rule.setAttributes(this.inputs);
        for (int i = 0; i < this.inputAtt; ++i) {
            if (this.inputs[i].getType() == 0) {
                Rule.setNumValue(Attributes.getInputAttribute(i).getNumNominalValues(), i);
                continue;
            }
            Rule.setNumValue(1, i);
        }
        this.ruleset = new Rule[this.trainData.length];
        Randomize.setSeed(this.seed);
        this.setInitialTime();
    }

    @Override
    protected void readParameters(String script) {
        String file = Fichero.leeFichero(script);
        StringTokenizer fileLines = new StringTokenizer(file, "\n\r");
        fileLines.nextToken();
        fileLines.nextToken();
        fileLines.nextToken();
        String line = fileLines.nextToken();
        StringTokenizer tokens = new StringTokenizer(line, "=");
        tokens.nextToken();
        this.seed = Long.parseLong(tokens.nextToken().substring(1));
    }

    public void getRules() {
        int i;
        int[] randomIndex = new int[this.trainData.length];
        for (i = 0; i < this.trainData.length; ++i) {
            randomIndex[i] = i;
        }
        for (i = 0; i < this.trainData.length; ++i) {
            int pos = Randomize.Randint(0, this.trainData.length);
            int tmp = randomIndex[i];
            randomIndex[i] = randomIndex[pos];
            randomIndex[pos] = tmp;
        }
        for (i = 0; i < this.trainData.length; ++i) {
            this.ruleset[i] = new Rule(this.trainData[randomIndex[i]], this.trainOutput[randomIndex[i]]);
        }
        boolean canMerge = true;
        while (canMerge) {
            canMerge = false;
            for (i = 0; i < this.ruleset.length && !canMerge; ++i) {
                int j;
                int indexMerge = -1;
                double distMerge = Double.MAX_VALUE;
                for (j = i + 1; j < this.ruleset.length; ++j) {
                    double auxDist;
                    if (this.ruleset[i].getOutput() != this.ruleset[j].getOutput() || !(distMerge > (auxDist = this.ruleset[i].distanceRule(this.ruleset[j])))) continue;
                    distMerge = auxDist;
                    indexMerge = j;
                }
                if (indexMerge <= -1) continue;
                Rule newRule = this.ruleset[i].clone();
                newRule.merge(this.ruleset[indexMerge]);
                boolean testing = true;
                for (j = 0; j < this.ruleset.length && testing; ++j) {
                    if (j == i || j == indexMerge || newRule.getOutput() == this.ruleset[j].getOutput() || !newRule.overlap(this.ruleset[j])) continue;
                    testing = false;
                }
                if (!testing) continue;
                this.ruleset[i] = newRule.clone();
                Rule[] newSet = new Rule[this.ruleset.length - 1];
                System.arraycopy(this.ruleset, 0, newSet, 0, indexMerge);
                System.arraycopy(this.ruleset, indexMerge + 1, newSet, indexMerge, this.ruleset.length - indexMerge - 1);
                this.ruleset = new Rule[newSet.length];
                System.arraycopy(newSet, 0, this.ruleset, 0, newSet.length);
                canMerge = true;
            }
        }
    }

    @Override
    protected int evaluate(double[] instance) {
        double minArea = Double.MAX_VALUE;
        double minDist = Double.MAX_VALUE;
        int selected = -1;
        for (int i = 0; i < this.ruleset.length; ++i) {
            if (this.ruleset[i].distance(instance) == minDist && this.ruleset[i].getArea() < minArea) {
                minArea = this.ruleset[i].getArea();
                selected = i;
            }
            if (!(this.ruleset[i].distance(instance) < minDist)) continue;
            minDist = this.ruleset[i].distance(instance);
            minArea = this.ruleset[i].getArea();
            selected = i;
        }
        selected = this.ruleset[selected].getOutput();
        return selected;
    }

    @Override
    protected int writeRules() {
        String text = "";
        text = text + "\n";
        for (int i = 0; i < this.ruleset.length; ++i) {
            text = text + "\n";
            text = text + this.ruleset[i];
        }
        this.ruleSetText = text;
        return this.ruleset.length;
    }
}

