/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.util.dataset;

import java.util.ArrayList;
import java.util.HashMap;
import net.sourceforge.jclec.util.dataset.IAttribute;
import net.sourceforge.jclec.util.dataset.IMetadata;

public class Metadata
implements IMetadata {
    protected ArrayList<IAttribute> attributesList = new ArrayList();
    protected HashMap<String, IAttribute> attributesMap = new HashMap();
    protected int classIndex;

    @Override
    public int numberOfAttributes() {
        return this.attributesList.size();
    }

    @Override
    public IAttribute getAttribute(String attributeName) {
        return this.attributesMap.get(attributeName);
    }

    @Override
    public IAttribute getAttribute(int attributeIndex) {
        return this.attributesList.get(attributeIndex);
    }

    @Override
    public int getIndex(IAttribute attribute) {
        return this.attributesList.indexOf(attribute);
    }

    @Override
    public int getIndex(String attributeName) {
        IAttribute attribute = this.attributesMap.get(attributeName);
        if (attribute == null) {
            return -1;
        }
        return this.attributesList.indexOf(attribute);
    }

    public boolean addAttribute(IAttribute attribute) {
        String attributeName = attribute.getName();
        if (attributeName == null || this.attributesMap.get(attributeName) != null) {
            return false;
        }
        this.attributesList.add(attribute);
        this.attributesMap.put(attributeName, attribute);
        return true;
    }

    public void setAttributesArray(IAttribute[] attributesArray) {
        this.attributesList.clear();
        this.attributesMap.clear();
        IAttribute[] iAttributeArray = attributesArray;
        int n = attributesArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAttribute attribute = iAttributeArray[n2];
            this.addAttribute(attribute);
            ++n2;
        }
    }

    @Override
    public int getClassIndex() {
        return this.classIndex;
    }

    @Override
    public void setClassIndex(int classIndex) {
        this.classIndex = classIndex;
    }
}

