/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.base;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jclec.IIndividual;
import net.sourceforge.jclec.IPopulation;
import net.sourceforge.jclec.ISelector;
import net.sourceforge.jclec.ISystem;

public abstract class AbstractSelector
implements ISelector {
    protected IPopulation context;
    protected transient List<IIndividual> actsrc;
    protected transient int actsrcsz;

    public AbstractSelector() {
    }

    public AbstractSelector(ISystem context) {
        this.contextualize(context);
    }

    @Override
    public void contextualize(ISystem context) {
        if (!(context instanceof IPopulation)) {
            throw new IllegalArgumentException("This object uses a population as execution context");
        }
        this.context = (IPopulation)context;
    }

    @Override
    public List<IIndividual> select(List<IIndividual> src) {
        return this.select(src, src.size());
    }

    @Override
    public List<IIndividual> select(List<IIndividual> src, int nofsel) {
        return this.select(src, nofsel, true);
    }

    @Override
    public List<IIndividual> select(List<IIndividual> src, int nofsel, boolean repeat) {
        this.actsrc = src;
        this.actsrcsz = src.size();
        this.prepareSelection();
        ArrayList<IIndividual> result = new ArrayList<IIndividual>();
        int i = 0;
        while (i < nofsel) {
            IIndividual selected = this.selectNext();
            if (!repeat) {
                while (result.contains(selected)) {
                    selected = this.selectNext();
                }
            }
            result.add(selected);
            ++i;
        }
        return result;
    }

    protected abstract void prepareSelection();

    protected abstract IIndividual selectNext();
}

