/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Preprocess.Missing_Values.kmeansImpute;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import keel.Algorithms.Preprocess.Missing_Values.kmeansImpute.FreqList;
import keel.Algorithms.Preprocess.Missing_Values.kmeansImpute.gCenter;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;
import org.core.Randomize;

public class kmeansImpute {
    double[] mean = null;
    double[] std_dev = null;
    double tempData = 0.0;
    String[][] X = null;
    FreqList[] timesSeen = null;
    String[] mostCommon;
    int ndatos = 0;
    int nentradas = 0;
    int tipo = 0;
    int direccion = 0;
    int nvariables = 0;
    int nsalidas = 0;
    int K = 1;
    long semilla = 12345678L;
    double minError = 1.0;
    int maxIter = 1000;
    InstanceSet IS;
    InstanceSet IStest;
    String input_train_name = new String();
    String input_test_name = new String();
    String output_train_name = new String();
    String output_test_name = new String();
    String temp = new String();
    String data_out = new String("");

    public kmeansImpute(String fileParam) {
        this.config_read(fileParam);
        this.IS = new InstanceSet();
        this.IStest = new InstanceSet();
    }

    private void write_results(String output) {
        try {
            FileWriter file_write = new FileWriter(output);
            file_write.write(this.IS.getHeader());
            file_write.write("@data\n");
            for (int i = 0; i < this.ndatos; ++i) {
                file_write.write(this.X[i][0]);
                for (int j = 1; j < this.nvariables; ++j) {
                    file_write.write("," + this.X[i][j]);
                }
                file_write.write("\n");
            }
            file_write.close();
        }
        catch (IOException e) {
            System.out.println("IO exception = " + e);
            System.exit(-1);
        }
    }

    private void config_read(String fileParam) {
        File inputFile = new File(fileParam);
        if (inputFile == null || !inputFile.exists()) {
            System.out.println("parameter " + fileParam + " file doesn't exists!");
            System.exit(-1);
        }
        try {
            String line;
            FileReader file_reader = new FileReader(inputFile);
            BufferedReader buf_reader = new BufferedReader(file_reader);
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            String[] out = line.split("algorithm = ");
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("inputData = ");
            out = out[1].split("\\s\"");
            this.input_train_name = new String(out[0].substring(1, out[0].length() - 1));
            this.input_test_name = new String(out[1].substring(0, out[1].length() - 1));
            if (this.input_test_name.charAt(this.input_test_name.length() - 1) == '\"') {
                this.input_test_name = this.input_test_name.substring(0, this.input_test_name.length() - 1);
            }
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("outputData = ");
            out = out[1].split("\\s\"");
            this.output_train_name = new String(out[0].substring(1, out[0].length() - 1));
            this.output_test_name = new String(out[1].substring(0, out[1].length() - 1));
            if (this.output_test_name.charAt(this.output_test_name.length() - 1) == '\"') {
                this.output_test_name = this.output_test_name.substring(0, this.output_test_name.length() - 1);
            }
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("seed = ");
            this.semilla = new Long(out[1]);
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("k = ");
            this.K = new Integer(out[1]);
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("error = ");
            this.minError = new Double(out[1]);
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("iterations = ");
            this.maxIter = new Integer(out[1]);
            file_reader.close();
        }
        catch (IOException e) {
            System.out.println("IO exception = " + e);
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private double distance(Instance i, Instance j) {
        double dist = 0.0;
        int in = 0;
        int out = 0;
        for (int l = 0; l < this.nvariables; ++l) {
            Attribute a = Attributes.getAttribute(l);
            this.direccion = a.getDirectionAttribute();
            this.tipo = a.getType();
            if (this.direccion == 1) {
                if (this.tipo != 0 && !i.getInputMissingValues(in)) {
                    dist += (i.getInputRealValues(in) - j.getInputRealValues(in)) * (i.getInputRealValues(in) - j.getInputRealValues(in));
                } else if (!i.getInputMissingValues(in) && i.getInputNominalValues(in) != j.getInputNominalValues(in)) {
                    dist += 1.0;
                }
                ++in;
                continue;
            }
            if (this.direccion != 2) continue;
            if (this.tipo != 0 && !i.getOutputMissingValues(out)) {
                dist += (i.getOutputRealValues(out) - j.getOutputRealValues(out)) * (i.getOutputRealValues(out) - j.getOutputRealValues(out));
            } else if (!i.getOutputMissingValues(out) && i.getOutputNominalValues(out) != j.getOutputNominalValues(out)) {
                dist += 1.0;
            }
            ++out;
        }
        return dist;
    }

    public void process() {
        Attribute a;
        int j;
        int actual;
        Instance inst;
        int i;
        int out;
        int in;
        Randomize rnd = new Randomize();
        gCenter kmeans = null;
        int iterations = 0;
        int totalMissing = 0;
        boolean allMissing = true;
        Randomize.setSeed(this.semilla);
        try {
            double E;
            this.IS.readSet(this.input_train_name, true);
            in = 0;
            out = 0;
            this.ndatos = this.IS.getNumInstances();
            this.nvariables = Attributes.getNumAttributes();
            this.nentradas = Attributes.getInputNumAttributes();
            this.nsalidas = Attributes.getOutputNumAttributes();
            this.X = new String[this.ndatos][this.nvariables];
            kmeans = new gCenter(this.K, this.ndatos, this.nvariables);
            this.timesSeen = new FreqList[this.nvariables];
            this.mostCommon = new String[this.nvariables];
            totalMissing = 0;
            for (i = 0; i < this.ndatos; ++i) {
                inst = this.IS.getInstance(i);
                if (!inst.existsAnyMissingValue()) continue;
                ++totalMissing;
            }
            allMissing = totalMissing == this.ndatos;
            for (int numMeans = 0; numMeans < this.K; ++numMeans) {
                Instance ex;
                while ((ex = this.IS.getInstance(actual = (int)((double)this.ndatos * rnd.Rand()))).existsAnyMissingValue() && !allMissing) {
                }
                kmeans.copyCenter(ex, numMeans);
            }
            double prevE = 0.0;
            iterations = 0;
            do {
                for (i = 0; i < this.ndatos; ++i) {
                    inst = this.IS.getInstance(i);
                    kmeans.setClusterOf(inst, i);
                }
                kmeans.recalculateCenters(this.IS);
                E = 0.0;
                for (i = 0; i < this.ndatos; ++i) {
                    inst = this.IS.getInstance(i);
                    E += kmeans.distance(inst, kmeans.getClusterOf(i));
                }
                ++iterations;
                if (Math.abs(prevE - E) == 0.0) {
                    iterations = this.maxIter;
                    continue;
                }
                prevE = E;
            } while (E > this.minError && iterations < this.maxIter);
            for (i = 0; i < this.ndatos; ++i) {
                inst = this.IS.getInstance(i);
                in = 0;
                out = 0;
                for (j = 0; j < this.nvariables; ++j) {
                    a = Attributes.getAttribute(j);
                    this.direccion = a.getDirectionAttribute();
                    this.tipo = a.getType();
                    if (this.direccion == 1) {
                        if (this.tipo != 0 && !inst.getInputMissingValues(in)) {
                            this.X[i][j] = new String(String.valueOf(inst.getInputRealValues(in)));
                        } else if (!inst.getInputMissingValues(in)) {
                            this.X[i][j] = inst.getInputNominalValues(in);
                        } else {
                            actual = kmeans.getClusterOf(i);
                            this.X[i][j] = new String(kmeans.valueAt(actual, j));
                        }
                        ++in;
                        continue;
                    }
                    if (this.direccion != 2) continue;
                    if (this.tipo != 0 && !inst.getOutputMissingValues(out)) {
                        this.X[i][j] = new String(String.valueOf(inst.getOutputRealValues(out)));
                    } else if (!inst.getOutputMissingValues(out)) {
                        this.X[i][j] = inst.getOutputNominalValues(out);
                    } else {
                        actual = kmeans.getClusterOf(i);
                        this.X[i][j] = new String(kmeans.valueAt(actual, j));
                    }
                    ++out;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Dataset exception = " + e);
            e.printStackTrace();
            System.exit(-1);
        }
        this.write_results(this.output_train_name);
        if (this.input_train_name.compareTo(this.input_test_name) != 0) {
            try {
                this.IStest.readSet(this.input_test_name, false);
                in = 0;
                out = 0;
                this.ndatos = this.IStest.getNumInstances();
                this.nvariables = Attributes.getNumAttributes();
                this.nentradas = Attributes.getInputNumAttributes();
                this.nsalidas = Attributes.getOutputNumAttributes();
                for (i = 0; i < this.ndatos; ++i) {
                    inst = this.IStest.getInstance(i);
                    in = 0;
                    out = 0;
                    for (j = 0; j < this.nvariables; ++j) {
                        a = Attributes.getAttribute(j);
                        this.direccion = a.getDirectionAttribute();
                        this.tipo = a.getType();
                        if (this.direccion == 1) {
                            if (this.tipo != 0 && !inst.getInputMissingValues(in)) {
                                this.X[i][j] = new String(String.valueOf(inst.getInputRealValues(in)));
                            } else if (!inst.getInputMissingValues(in)) {
                                this.X[i][j] = inst.getInputNominalValues(in);
                            } else {
                                actual = kmeans.getClusterOf(i);
                                this.X[i][j] = new String(kmeans.valueAt(actual, j));
                            }
                            ++in;
                            continue;
                        }
                        if (this.direccion != 2) continue;
                        if (this.tipo != 0 && !inst.getOutputMissingValues(out)) {
                            this.X[i][j] = new String(String.valueOf(inst.getOutputRealValues(out)));
                        } else if (!inst.getOutputMissingValues(out)) {
                            this.X[i][j] = inst.getOutputNominalValues(out);
                        } else {
                            actual = kmeans.getClusterOf(i);
                            this.X[i][j] = new String(kmeans.valueAt(actual, j));
                        }
                        ++out;
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Dataset exception = " + e);
                e.printStackTrace();
                System.exit(-1);
            }
            this.write_results(this.output_test_name);
        }
    }
}

