/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.intarray;

import net.sourceforge.jclec.IFitness;
import net.sourceforge.jclec.IIndividual;
import net.sourceforge.jclec.base.AbstractIndividual;
import org.apache.commons.lang.builder.EqualsBuilder;

public class IntArrayIndividual
extends AbstractIndividual<int[]> {
    private static final long serialVersionUID = -2908949095129168050L;

    public IntArrayIndividual() {
    }

    public IntArrayIndividual(int[] genotype) {
        super(genotype);
    }

    public IntArrayIndividual(int[] genotype, IFitness fitness) {
        super(genotype, fitness);
    }

    @Override
    public IIndividual copy() {
        int gl = ((int[])this.genotype).length;
        int[] gother = new int[((int[])this.genotype).length];
        System.arraycopy(this.genotype, 0, gother, 0, gl);
        if (this.fitness != null) {
            return new IntArrayIndividual(gother, this.fitness.copy());
        }
        return new IntArrayIndividual(gother);
    }

    @Override
    public double distance(IIndividual other) {
        int[] gother = (int[])((IntArrayIndividual)other).genotype;
        double distance = 0.0;
        int gl = ((int[])this.genotype).length;
        int i = 0;
        while (i < gl) {
            double aux = ((int[])this.genotype)[i] - gother[i];
            distance += aux >= 0.0 ? aux : -aux;
            ++i;
        }
        return distance;
    }

    public boolean equals(Object other) {
        if (other instanceof IntArrayIndividual) {
            IntArrayIndividual iaother = (IntArrayIndividual)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append((int[])this.genotype, (int[])iaother.genotype);
            eb.append(this.fitness, iaother.fitness);
            return eb.isEquals();
        }
        return false;
    }
}

