/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.M5;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import keel.Algorithms.Decision_Trees.M5.Information;
import keel.Algorithms.Decision_Trees.M5.M5Attribute;
import keel.Algorithms.Decision_Trees.M5.M5Instance;
import keel.Algorithms.Decision_Trees.M5.M5Instances;
import keel.Algorithms.Decision_Trees.M5.M5SparseInstance;
import keel.Algorithms.Decision_Trees.M5.M5StaticUtils;
import keel.Algorithms.Decision_Trees.M5.M5Vector;
import keel.Algorithms.Decision_Trees.M5.Queue;

public class NominalToBinaryFilter {
    private int[][] m_Indices = null;
    private boolean m_Numeric = true;
    private boolean m_Debug = false;
    private M5Instances m_OutputFormat = null;
    private Queue m_OutputQueue = null;
    private int[] m_OutputStringAtts = null;
    private int[] m_InputStringAtts = null;
    private M5Instances m_InputFormat = null;
    protected boolean m_NewBatch = true;

    protected void setOutputFormat(M5Instances outputFormat) {
        if (outputFormat != null) {
            this.m_OutputFormat = outputFormat.stringFreeStructure();
            this.m_OutputStringAtts = this.getStringIndices(this.m_OutputFormat);
            String relationName = outputFormat.relationName() + "-" + this.getClass().getName();
            if (this instanceof NominalToBinaryFilter) {
                String[] options = this.getOptions();
                for (int i = 0; i < options.length; ++i) {
                    relationName = relationName + options[i].trim();
                }
            }
            this.m_OutputFormat.setRelationName(relationName);
        } else {
            this.m_OutputFormat = null;
        }
        this.m_OutputQueue = new Queue();
    }

    protected M5Instances getInputFormat() {
        return this.m_InputFormat;
    }

    protected M5Instances outputFormatPeek() {
        return this.m_OutputFormat;
    }

    protected void push(M5Instance instance) {
        if (instance != null) {
            this.copyStringValues(instance, this.m_OutputFormat, this.m_OutputStringAtts);
            instance.setDataset(this.m_OutputFormat);
            this.m_OutputQueue.push(instance);
        }
    }

    protected void resetQueue() {
        this.m_OutputQueue = new Queue();
    }

    protected void bufferInput(M5Instance instance) {
        if (instance != null) {
            this.copyStringValues(instance, this.m_InputFormat, this.m_InputStringAtts);
            instance.setDataset(this.m_InputFormat);
            this.m_InputFormat.add(instance);
        }
    }

    protected int[] getInputStringIndex() {
        return this.m_InputStringAtts;
    }

    protected int[] getOutputStringIndex() {
        return this.m_OutputStringAtts;
    }

    private void copyStringValues(M5Instance inst, M5Instances destDataset, int[] strAtts) {
        if (strAtts.length == 0) {
            return;
        }
        if (inst.dataset() == null) {
            throw new IllegalArgumentException("Instance has no dataset assigned!!");
        }
        if (inst.dataset().numAttributes() != destDataset.numAttributes()) {
            throw new IllegalArgumentException("Src and Dest differ in # of attributes!!");
        }
        this.copyStringValues(inst, true, inst.dataset(), strAtts, destDataset, strAtts);
    }

    protected void copyStringValues(M5Instance instance, boolean instSrcCompat, M5Instances srcDataset, M5Instances destDataset) {
        this.copyStringValues(instance, instSrcCompat, srcDataset, this.m_InputStringAtts, destDataset, this.m_OutputStringAtts);
    }

    protected void copyStringValues(M5Instance instance, boolean instSrcCompat, M5Instances srcDataset, int[] srcStrAtts, M5Instances destDataset, int[] destStrAtts) {
        if (srcDataset == destDataset) {
            return;
        }
        if (srcStrAtts.length != destStrAtts.length) {
            throw new IllegalArgumentException("Src and Dest string indices differ in length!!");
        }
        for (int i = 0; i < srcStrAtts.length; ++i) {
            int instIndex = instSrcCompat ? srcStrAtts[i] : destStrAtts[i];
            M5Attribute src = srcDataset.attribute(srcStrAtts[i]);
            M5Attribute dest = destDataset.attribute(destStrAtts[i]);
            if (instance.isMissing(instIndex)) continue;
            int valIndex = dest.addStringValue(src, (int)instance.value(instIndex));
            instance.setValue(instIndex, (double)valIndex);
        }
    }

    protected void flushInput() {
        if (this.m_InputStringAtts.length > 0) {
            this.m_InputFormat = this.m_InputFormat.stringFreeStructure();
        } else {
            this.m_InputFormat.delete();
        }
    }

    public boolean inputFormat(M5Instances instanceInfo) throws Exception {
        return this.setInputFormat(instanceInfo);
    }

    public final M5Instances outputFormat() {
        return this.getOutputFormat();
    }

    public final M5Instances getOutputFormat() {
        if (this.m_OutputFormat == null) {
            throw new NullPointerException("No output format defined.");
        }
        return new M5Instances(this.m_OutputFormat, 0);
    }

    public M5Instance output() {
        if (this.m_OutputFormat == null) {
            throw new NullPointerException("No output instance format defined");
        }
        if (this.m_OutputQueue.empty()) {
            return null;
        }
        M5Instance result = (M5Instance)this.m_OutputQueue.pop();
        if (this.m_OutputQueue.empty() && this.m_NewBatch && this.m_OutputStringAtts.length > 0) {
            this.m_OutputFormat = this.m_OutputFormat.stringFreeStructure();
        }
        return result;
    }

    public M5Instance outputPeek() {
        if (this.m_OutputFormat == null) {
            throw new NullPointerException("No output instance format defined");
        }
        if (this.m_OutputQueue.empty()) {
            return null;
        }
        M5Instance result = (M5Instance)this.m_OutputQueue.peek();
        return result;
    }

    public int numPendingOutput() {
        if (this.m_OutputFormat == null) {
            throw new NullPointerException("No output instance format defined");
        }
        return this.m_OutputQueue.size();
    }

    public boolean isOutputFormatDefined() {
        return this.m_OutputFormat != null;
    }

    protected int[] getStringIndices(M5Instances insts) {
        int[] index = new int[insts.numAttributes()];
        int indexSize = 0;
        for (int i = 0; i < insts.numAttributes(); ++i) {
            if (insts.attribute(i).type() != 2) continue;
            index[indexSize++] = i;
        }
        int[] result = new int[indexSize];
        System.arraycopy(index, 0, result, 0, indexSize);
        return result;
    }

    public static M5Instances useFilter(M5Instances data, NominalToBinaryFilter filter) throws Exception {
        M5Instance processed;
        for (int i = 0; i < data.numInstances(); ++i) {
            filter.input(data.instance(i));
        }
        filter.batchFinished();
        M5Instances newData = filter.getOutputFormat();
        while ((processed = filter.output()) != null) {
            newData.add(processed);
        }
        return newData;
    }

    public static void filterFile(NominalToBinaryFilter filter, String[] options) throws Exception {
        boolean debug = false;
        M5Instances data = null;
        BufferedReader input = null;
        PrintWriter output = null;
        try {
            boolean helpRequest = M5StaticUtils.getFlag('h', options);
            if (M5StaticUtils.getFlag('d', options)) {
                debug = true;
            }
            String infileName = M5StaticUtils.getOption('i', options);
            String outfileName = M5StaticUtils.getOption('o', options);
            String classIndex = M5StaticUtils.getOption('c', options);
            if (filter instanceof NominalToBinaryFilter) {
                filter.setOptions(options);
            }
            M5StaticUtils.checkForRemainingOptions(options);
            if (helpRequest) {
                throw new Exception("Help requested.\n");
            }
            input = infileName.length() != 0 ? new BufferedReader(new FileReader(infileName)) : new BufferedReader(new InputStreamReader(System.in));
            output = outfileName.length() != 0 ? new PrintWriter(new FileOutputStream(outfileName)) : new PrintWriter(System.out);
            data = new M5Instances(input, 1);
            if (classIndex.length() != 0) {
                if (classIndex.equals("first")) {
                    data.setClassIndex(0);
                } else if (classIndex.equals("last")) {
                    data.setClassIndex(data.numAttributes() - 1);
                } else {
                    data.setClassIndex(Integer.parseInt(classIndex) - 1);
                }
            }
        }
        catch (Exception ex) {
            String filterOptions = "";
            if (filter instanceof NominalToBinaryFilter) {
                filterOptions = filterOptions + "\nFilter options:\n\n";
                Enumeration enuma = filter.listOptions();
                while (enuma.hasMoreElements()) {
                    Information option = (Information)enuma.nextElement();
                    filterOptions = filterOptions + option.synopsis() + '\n' + option.description() + "\n";
                }
            }
            String genericOptions = "\nGeneral options:\n\n-h\n\tGet help on available options.\n\t(use -b -h for help on batch mode.)\n-i <file>\n\tThe name of the file containing input instances.\n\tIf not supplied then instances will be read from stdin.\n-o <file>\n\tThe name of the file output instances will be written to.\n\tIf not supplied then instances will be written to stdout.\n-c <class index>\n\tThe number of the attribute to use as the class.\n\t\"first\" and \"last\" are also valid entries.\n\tIf not supplied then no class is assigned.\n";
            throw new Exception('\n' + ex.getMessage() + filterOptions + genericOptions);
        }
        if (debug) {
            System.err.println("Setting input format");
        }
        boolean printedHeader = false;
        if (filter.setInputFormat(data)) {
            if (debug) {
                System.err.println("Getting output format");
            }
            output.println(filter.getOutputFormat().toString());
            printedHeader = true;
        }
        while (data.readInstance(input)) {
            if (debug) {
                System.err.println("Input instance to filter");
            }
            if (filter.input(data.instance(0))) {
                if (debug) {
                    System.err.println("Filter said collect immediately");
                }
                if (!printedHeader) {
                    throw new Error("Filter didn't return true from setInputFormat() earlier!");
                }
                if (debug) {
                    System.err.println("Getting output instance");
                }
                output.println(filter.output().toString());
            }
            data.delete(0);
        }
        if (debug) {
            System.err.println("Setting end of batch");
        }
        if (filter.batchFinished()) {
            if (debug) {
                System.err.println("Filter said collect output");
            }
            if (!printedHeader) {
                if (debug) {
                    System.err.println("Getting output format");
                }
                output.println(filter.getOutputFormat().toString());
            }
            if (debug) {
                System.err.println("Getting output instance");
            }
            while (filter.numPendingOutput() > 0) {
                output.println(filter.output().toString());
                if (!debug) continue;
                System.err.println("Getting output instance");
            }
        }
        if (debug) {
            System.err.println("Done");
        }
        if (output != null) {
            output.close();
        }
    }

    public static void batchFilterFile(NominalToBinaryFilter filter, String[] options) throws Exception {
        M5Instances firstData = null;
        M5Instances secondData = null;
        BufferedReader firstInput = null;
        BufferedReader secondInput = null;
        PrintWriter firstOutput = null;
        PrintWriter secondOutput = null;
        try {
            boolean helpRequest = M5StaticUtils.getFlag('h', options);
            String fileName = M5StaticUtils.getOption('i', options);
            if (fileName.length() == 0) {
                throw new Exception("No first input file given.\n");
            }
            firstInput = new BufferedReader(new FileReader(fileName));
            fileName = M5StaticUtils.getOption('r', options);
            if (fileName.length() == 0) {
                throw new Exception("No second input file given.\n");
            }
            secondInput = new BufferedReader(new FileReader(fileName));
            fileName = M5StaticUtils.getOption('o', options);
            firstOutput = fileName.length() != 0 ? new PrintWriter(new FileOutputStream(fileName)) : new PrintWriter(System.out);
            fileName = M5StaticUtils.getOption('s', options);
            secondOutput = fileName.length() != 0 ? new PrintWriter(new FileOutputStream(fileName)) : new PrintWriter(System.out);
            String classIndex = M5StaticUtils.getOption('c', options);
            if (filter instanceof NominalToBinaryFilter) {
                filter.setOptions(options);
            }
            M5StaticUtils.checkForRemainingOptions(options);
            if (helpRequest) {
                throw new Exception("Help requested.\n");
            }
            secondData = new M5Instances(secondInput, 1);
            firstData = new M5Instances(firstInput, 1);
            if (!secondData.equalHeaders(firstData)) {
                throw new Exception("Input file formats differ.\n");
            }
            if (classIndex.length() != 0) {
                if (classIndex.equals("first")) {
                    firstData.setClassIndex(0);
                    secondData.setClassIndex(0);
                } else if (classIndex.equals("last")) {
                    firstData.setClassIndex(firstData.numAttributes() - 1);
                    secondData.setClassIndex(secondData.numAttributes() - 1);
                } else {
                    firstData.setClassIndex(Integer.parseInt(classIndex) - 1);
                    secondData.setClassIndex(Integer.parseInt(classIndex) - 1);
                }
            }
        }
        catch (Exception ex) {
            String filterOptions = "";
            if (filter instanceof NominalToBinaryFilter) {
                filterOptions = filterOptions + "\nFilter options:\n\n";
                Enumeration enume = filter.listOptions();
                while (enume.hasMoreElements()) {
                    Information option = (Information)enume.nextElement();
                    filterOptions = filterOptions + option.synopsis() + '\n' + option.description() + "\n";
                }
            }
            String genericOptions = "\nGeneral options:\n\n-h\n\tGet help on available options.\n-i <filename>\n\tThe file containing first input instances.\n-o <filename>\n\tThe file first output instances will be written to.\n-r <filename>\n\tThe file containing second input instances.\n-s <filename>\n\tThe file second output instances will be written to.\n-c <class index>\n\tThe number of the attribute to use as the class.\n\t\"first\" and \"last\" are also valid entries.\n\tIf not supplied then no class is assigned.\n";
            throw new Exception('\n' + ex.getMessage() + filterOptions + genericOptions);
        }
        boolean printedHeader = false;
        if (filter.setInputFormat(firstData)) {
            firstOutput.println(filter.getOutputFormat().toString());
            printedHeader = true;
        }
        while (firstData.readInstance(firstInput)) {
            if (filter.input(firstData.instance(0))) {
                if (!printedHeader) {
                    throw new Error("Filter didn't return true from setInputFormat() earlier!");
                }
                firstOutput.println(filter.output().toString());
            }
            firstData.delete(0);
        }
        if (filter.batchFinished()) {
            if (!printedHeader) {
                firstOutput.println(filter.getOutputFormat().toString());
            }
            while (filter.numPendingOutput() > 0) {
                firstOutput.println(filter.output().toString());
            }
        }
        if (firstOutput != null) {
            firstOutput.close();
        }
        printedHeader = false;
        if (filter.isOutputFormatDefined()) {
            secondOutput.println(filter.getOutputFormat().toString());
            printedHeader = true;
        }
        while (secondData.readInstance(secondInput)) {
            if (filter.input(secondData.instance(0))) {
                if (!printedHeader) {
                    throw new Error("Filter didn't return true from isOutputFormatDefined() earlier!");
                }
                secondOutput.println(filter.output().toString());
            }
            secondData.delete(0);
        }
        if (filter.batchFinished()) {
            if (!printedHeader) {
                secondOutput.println(filter.getOutputFormat().toString());
            }
            while (filter.numPendingOutput() > 0) {
                secondOutput.println(filter.output().toString());
            }
        }
        if (secondOutput != null) {
            secondOutput.close();
        }
    }

    public boolean setInputFormat(M5Instances instanceInfo) throws Exception {
        this.superSetInputFormat(instanceInfo);
        if (instanceInfo.classIndex() < 0) {
            throw new Exception("No class has been assigned to the instances");
        }
        this.setOutputFormat();
        this.m_Indices = null;
        return instanceInfo.classAttribute().isNominal();
    }

    public boolean superSetInputFormat(M5Instances instanceInfo) throws Exception {
        this.m_InputFormat = instanceInfo.stringFreeStructure();
        this.m_InputStringAtts = this.getStringIndices(instanceInfo);
        this.m_OutputFormat = null;
        this.m_OutputQueue = new Queue();
        this.m_NewBatch = true;
        return false;
    }

    public boolean input(M5Instance instance) throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.m_Indices != null || this.getInputFormat().classAttribute().isNominal()) {
            this.convertInstance(instance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    public boolean batchFinished() throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_Indices == null && this.getInputFormat().classAttribute().isNumeric()) {
            this.computeAverageClassValues();
            this.setOutputFormat();
            for (int i = 0; i < this.getInputFormat().numInstances(); ++i) {
                this.convertInstance(this.getInputFormat().instance(i));
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    public Enumeration listOptions() {
        Vector<Information> newVector = new Vector<Information>(1);
        newVector.addElement(new Information("\tSets if binary attributes are to be coded as nominal ones.", "N", 0, "-N"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.setBinaryAttributesNominal(M5StaticUtils.getFlag('N', options));
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        String[] options = new String[1];
        int current = 0;
        if (this.getBinaryAttributesNominal()) {
            options[current++] = "-N";
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public boolean getBinaryAttributesNominal() {
        return !this.m_Numeric;
    }

    public void setBinaryAttributesNominal(boolean bool) {
        this.m_Numeric = !bool;
    }

    private void computeAverageClassValues() throws Exception {
        double[][] avgClassValues = new double[this.getInputFormat().numAttributes()][0];
        this.m_Indices = new int[this.getInputFormat().numAttributes()][0];
        for (int j = 0; j < this.getInputFormat().numAttributes(); ++j) {
            M5Attribute att = this.getInputFormat().attribute(j);
            if (!att.isNominal()) continue;
            avgClassValues[j] = new double[att.numValues()];
            double[] counts = new double[att.numValues()];
            for (int i = 0; i < this.getInputFormat().numInstances(); ++i) {
                M5Instance instance = this.getInputFormat().instance(i);
                if (instance.classIsMissing() || instance.isMissing(j)) continue;
                int n = (int)instance.value(j);
                counts[n] = counts[n] + instance.weight();
                double[] dArray = avgClassValues[j];
                int n2 = (int)instance.value(j);
                dArray[n2] = dArray[n2] + instance.weight() * instance.classValue();
            }
            double sum = M5StaticUtils.sum(avgClassValues[j]);
            double totalCounts = M5StaticUtils.sum(counts);
            if (M5StaticUtils.gr(totalCounts, 0.0)) {
                for (int k = 0; k < att.numValues(); ++k) {
                    if (M5StaticUtils.gr(counts[k], 0.0)) {
                        double[] dArray = avgClassValues[j];
                        int n = k;
                        dArray[n] = dArray[n] / counts[k];
                        continue;
                    }
                    avgClassValues[j][k] = sum / totalCounts;
                }
            }
            this.m_Indices[j] = M5StaticUtils.sort(avgClassValues[j]);
        }
    }

    private void setOutputFormat() throws Exception {
        if (this.getInputFormat().classAttribute().isNominal()) {
            this.setOutputFormatNominal();
        } else {
            this.setOutputFormatNumeric();
        }
    }

    private void convertInstance(M5Instance inst) throws Exception {
        if (this.getInputFormat().classAttribute().isNominal()) {
            this.convertInstanceNominal(inst);
        } else {
            this.convertInstanceNumeric(inst);
        }
    }

    private void setOutputFormatNominal() {
        int newClassIndex = this.getInputFormat().classIndex();
        M5Vector newAtts = new M5Vector();
        for (int j = 0; j < this.getInputFormat().numAttributes(); ++j) {
            M5Attribute att = this.getInputFormat().attribute(j);
            if (!att.isNominal() || j == this.getInputFormat().classIndex()) {
                newAtts.addElement(att.copy());
                continue;
            }
            if (att.numValues() <= 2) {
                if (this.m_Numeric) {
                    newAtts.addElement(new M5Attribute(att.name()));
                    continue;
                }
                newAtts.addElement(att.copy());
                continue;
            }
            if (j < this.getInputFormat().classIndex()) {
                newClassIndex += att.numValues() - 1;
            }
            for (int k = 0; k < att.numValues(); ++k) {
                StringBuffer attributeName = new StringBuffer(att.name() + "=");
                attributeName.append(att.value(k));
                if (this.m_Numeric) {
                    newAtts.addElement(new M5Attribute(attributeName.toString()));
                    continue;
                }
                M5Vector vals = new M5Vector(2);
                vals.addElement("f");
                vals.addElement("t");
                newAtts.addElement(new M5Attribute(attributeName.toString(), vals));
            }
        }
        M5Instances outputFormat = new M5Instances(this.getInputFormat().relationName(), newAtts, 0);
        outputFormat.setClassIndex(newClassIndex);
        this.setOutputFormat(outputFormat);
    }

    private void setOutputFormatNumeric() {
        if (this.m_Indices == null) {
            this.setOutputFormat(null);
            return;
        }
        int newClassIndex = this.getInputFormat().classIndex();
        M5Vector newAtts = new M5Vector();
        for (int j = 0; j < this.getInputFormat().numAttributes(); ++j) {
            M5Attribute att = this.getInputFormat().attribute(j);
            if (!att.isNominal() || j == this.getInputFormat().classIndex()) {
                newAtts.addElement(att.copy());
                continue;
            }
            if (j < this.getInputFormat().classIndex()) {
                newClassIndex += att.numValues() - 2;
            }
            for (int k = 1; k < att.numValues(); ++k) {
                StringBuffer attributeName = new StringBuffer(att.name() + "=");
                for (int l = k; l < att.numValues(); ++l) {
                    if (l > k) {
                        attributeName.append(',');
                    }
                    attributeName.append(att.value(this.m_Indices[j][l]));
                }
                if (this.m_Numeric) {
                    newAtts.addElement(new M5Attribute(attributeName.toString()));
                    continue;
                }
                M5Vector vals = new M5Vector(2);
                vals.addElement("f");
                vals.addElement("t");
                newAtts.addElement(new M5Attribute(attributeName.toString(), vals));
            }
        }
        M5Instances outputFormat = new M5Instances(this.getInputFormat().relationName(), newAtts, 0);
        outputFormat.setClassIndex(newClassIndex);
        this.setOutputFormat(outputFormat);
    }

    private void convertInstanceNominal(M5Instance instance) {
        double[] vals = new double[this.outputFormatPeek().numAttributes()];
        int attSoFar = 0;
        for (int j = 0; j < this.getInputFormat().numAttributes(); ++j) {
            int k;
            M5Attribute att = this.getInputFormat().attribute(j);
            if (!att.isNominal() || j == this.getInputFormat().classIndex()) {
                vals[attSoFar] = instance.value(j);
                ++attSoFar;
                continue;
            }
            if (att.numValues() <= 2) {
                vals[attSoFar] = instance.value(j);
                ++attSoFar;
                continue;
            }
            if (instance.isMissing(j)) {
                for (k = 0; k < att.numValues(); ++k) {
                    vals[attSoFar + k] = instance.value(j);
                }
            } else {
                for (k = 0; k < att.numValues(); ++k) {
                    vals[attSoFar + k] = k == (int)instance.value(j) ? 1.0 : 0.0;
                }
            }
            attSoFar += att.numValues();
        }
        M5Instance inst = null;
        inst = instance instanceof M5SparseInstance ? new M5SparseInstance(instance.weight(), vals) : new M5Instance(instance.weight(), vals);
        this.copyStringValues(inst, false, instance.dataset(), this.getInputStringIndex(), this.getOutputFormat(), this.getOutputStringIndex());
        inst.setDataset(this.getOutputFormat());
        this.push(inst);
    }

    private void convertInstanceNumeric(M5Instance instance) {
        double[] vals = new double[this.outputFormatPeek().numAttributes()];
        int attSoFar = 0;
        for (int j = 0; j < this.getInputFormat().numAttributes(); ++j) {
            int k;
            M5Attribute att = this.getInputFormat().attribute(j);
            if (!att.isNominal() || j == this.getInputFormat().classIndex()) {
                vals[attSoFar] = instance.value(j);
                ++attSoFar;
                continue;
            }
            if (instance.isMissing(j)) {
                for (k = 0; k < att.numValues() - 1; ++k) {
                    vals[attSoFar + k] = instance.value(j);
                }
            } else {
                k = 0;
                while ((int)instance.value(j) != this.m_Indices[j][k]) {
                    vals[attSoFar + k] = 1.0;
                    ++k;
                }
                while (k < att.numValues() - 1) {
                    vals[attSoFar + k] = 0.0;
                    ++k;
                }
            }
            attSoFar += att.numValues() - 1;
        }
        M5Instance inst = null;
        inst = instance instanceof M5SparseInstance ? new M5SparseInstance(instance.weight(), vals) : new M5Instance(instance.weight(), vals);
        this.copyStringValues(inst, false, instance.dataset(), this.getInputStringIndex(), this.getOutputFormat(), this.getOutputStringIndex());
        inst.setDataset(this.getOutputFormat());
        this.push(inst);
    }
}

