/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

public class SpectralPeaks {
    public final AR ar;
    public final Tukey tu;
    public static final SpectralPeaks NONE = new SpectralPeaks(AR.none, Tukey.none);
    public static final SpectralPeaks UNDEF = new SpectralPeaks(AR.undef, Tukey.undef);
    public static final SpectralPeaks ALL = new SpectralPeaks(AR.A, Tukey.T);

    public SpectralPeaks(AR ar, Tukey tu) {
        this.ar = ar;
        this.tu = tu;
    }

    public boolean hasHighPeak() {
        return this.ar == AR.A || this.tu == Tukey.T;
    }

    public boolean hasPeak() {
        return this.ar.isPresent() || this.tu.isPresent();
    }

    public int hashCode() {
        int hash = 3;
        hash = 73 * hash + (this.ar != null ? this.ar.hashCode() : 0);
        hash = 73 * hash + (this.tu != null ? this.tu.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof SpectralPeaks && this.equals((SpectralPeaks)obj);
    }

    public boolean equals(SpectralPeaks peaks) {
        return this.ar == peaks.ar && this.tu == peaks.tu;
    }

    private char ar() {
        if (this.ar == AR.A) {
            return 'A';
        }
        if (this.ar == AR.a) {
            return 'a';
        }
        if (this.ar == AR.none) {
            return '-';
        }
        return 'n';
    }

    public char tu() {
        if (this.tu == Tukey.T) {
            return 'T';
        }
        if (this.tu == Tukey.t) {
            return 't';
        }
        if (this.tu == Tukey.none) {
            return '-';
        }
        return 'n';
    }

    public String toString() {
        char[] s = new char[]{this.ar(), this.tu()};
        return new String(s);
    }

    public static boolean hasSeasonalPeaks(SpectralPeaks[] peaks) {
        if (peaks == null) {
            return false;
        }
        if (peaks.length == 6) {
            return SpectralPeaks.hasMonthlyPeaks(peaks);
        }
        if (peaks.length == 2) {
            return SpectralPeaks.hasQuarterlyPeaks(peaks);
        }
        if (peaks.length == 1) {
            return SpectralPeaks.hasHalfYearlyPreaks(peaks);
        }
        return false;
    }

    public static boolean hasHighSeasonalPeaks(SpectralPeaks[] peaks) {
        if (peaks.length == 6) {
            return SpectralPeaks.hasHighMonthlyPeaks(peaks);
        }
        if (peaks.length == 2) {
            return SpectralPeaks.hasHighQuarterlyPeaks(peaks);
        }
        if (peaks.length == 1) {
            return SpectralPeaks.hasHighHalfYearlyPreaks(peaks);
        }
        return false;
    }

    private static boolean hasMonthlyPeaks(SpectralPeaks[] peaks) {
        int n = 0;
        int nd = 0;
        for (int i = 0; i < peaks.length; ++i) {
            if (!peaks[i].hasPeak()) continue;
            ++n;
            if (!peaks[i].equals(ALL)) continue;
            ++nd;
        }
        switch (n) {
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
            case 3: {
                return nd >= 1 || !peaks[5].hasPeak();
            }
            case 2: {
                if (peaks[5].equals(ALL) && nd == 2) {
                    return true;
                }
                if (peaks[5].equals(NONE)) {
                    return nd >= 1;
                }
                return false;
            }
        }
        return false;
    }

    private static boolean hasHighMonthlyPeaks(SpectralPeaks[] peaks) {
        int n = 0;
        int nd = 0;
        for (int i = 0; i < peaks.length; ++i) {
            if (!peaks[i].hasHighPeak()) continue;
            ++n;
            if (!peaks[i].equals(ALL)) continue;
            ++nd;
        }
        switch (n) {
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
            case 3: {
                return nd >= 1 || !peaks[5].hasHighPeak();
            }
            case 2: {
                if (peaks[5].equals(ALL)) {
                    return nd == 2;
                }
                return nd >= 1;
            }
        }
        return false;
    }

    private static boolean hasHighQuarterlyPeaks(SpectralPeaks[] peaks) {
        if (peaks[0].equals(ALL)) {
            return true;
        }
        int n = 0;
        for (int i = 0; i < peaks.length; ++i) {
            if (!peaks[i].hasHighPeak()) continue;
            ++n;
        }
        return n == 2;
    }

    private static boolean hasQuarterlyPeaks(SpectralPeaks[] peaks) {
        if (peaks[0].equals(ALL)) {
            return true;
        }
        int n = 0;
        for (int i = 0; i < peaks.length; ++i) {
            if (!peaks[i].hasPeak()) continue;
            ++n;
        }
        return n == 2;
    }

    private static boolean hasHalfYearlyPreaks(SpectralPeaks[] peaks) {
        return peaks[0].hasPeak();
    }

    private static boolean hasHighHalfYearlyPreaks(SpectralPeaks[] peaks) {
        return peaks[0].hasHighPeak();
    }

    public static String format(SpectralPeaks[] peaks) {
        StringBuilder builder = new StringBuilder();
        if (peaks != null) {
            for (int i = 0; i < peaks.length; ++i) {
                if (i != 0) {
                    builder.append('.');
                }
                builder.append(peaks[i].toString());
            }
        }
        return builder.toString();
    }

    public static enum AR {
        A,
        a,
        none,
        undef;


        public boolean isPresent() {
            return this == A || this == a;
        }

        public static AR fromInt(int v) {
            switch (v) {
                case 0: {
                    return none;
                }
                case 1: {
                    return a;
                }
                case 2: {
                    return A;
                }
            }
            return undef;
        }
    }

    public static enum Tukey {
        T,
        t,
        none,
        undef;


        public boolean isPresent() {
            return this == T || this == t;
        }

        public static Tukey fromInt(int v) {
            switch (v) {
                case 0: {
                    return none;
                }
                case 1: {
                    return t;
                }
                case 2: {
                    return T;
                }
            }
            return undef;
        }
    }
}

