/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.realfunctions.riso;

import ec.tstoolkit.algorithm.IProcessingHook;
import ec.tstoolkit.algorithm.ProcessingHookProvider;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.realfunctions.IFunction;
import ec.tstoolkit.maths.realfunctions.IFunctionDerivatives;
import ec.tstoolkit.maths.realfunctions.IFunctionInstance;
import ec.tstoolkit.maths.realfunctions.IFunctionMinimizer;
import ec.tstoolkit.maths.realfunctions.riso.Lbfgs;

public class LbfgsMinimizer
extends ProcessingHookProvider<LbfgsMinimizer, IFunctionInstance>
implements IFunctionMinimizer {
    private static final int MAX_FAILED = 100;
    private double m_xtol = 1.0E-9;
    private double m_gtol = 1.0E-5;
    private int m_maxiter = 100;
    private int m_nfailed;
    private Lbfgs m_lbfgs = new Lbfgs();
    private double m_eps = 1.0E-9;
    private int m_m = 7;
    private IFunction m_fn;
    private IFunctionInstance m_fcur;
    private boolean m_converged;

    @Override
    public IFunctionMinimizer exemplar() {
        LbfgsMinimizer min = new LbfgsMinimizer();
        min.m_eps = this.m_eps;
        min.m_m = this.m_m;
        min.m_maxiter = this.m_maxiter;
        min.m_xtol = this.m_xtol;
        min.m_gtol = this.m_gtol;
        min.copyHooks(this);
        return min;
    }

    @Override
    public double getConvergenceCriterion() {
        return this.m_eps;
    }

    @Override
    public Matrix getCurvature() {
        return this.m_fn.getDerivatives(this.m_fcur).getHessian();
    }

    @Override
    public double[] getGradient() {
        return this.m_fn.getDerivatives(this.m_fcur).getGradient();
    }

    public double getGTol() {
        return this.m_gtol;
    }

    @Override
    public int getIterCount() {
        return this.m_lbfgs.getNIter();
    }

    @Override
    public int getMaxIter() {
        return this.m_maxiter;
    }

    public int getNIter() {
        return this.m_lbfgs.getNIter();
    }

    @Override
    public IFunctionInstance getResult() {
        return this.m_fcur;
    }

    @Override
    public double getObjective() {
        return this.m_fcur == null ? Double.NaN : this.m_fcur.getValue();
    }

    public double getXTol() {
        return this.m_xtol;
    }

    @Override
    public boolean minimize(IFunction function, IFunctionInstance start) {
        this.m_fn = function;
        this.m_fcur = start;
        this.m_converged = false;
        IReadDataBlock px = this.m_fcur.getParameters();
        int n = px.getLength();
        if (n == 0) {
            return true;
        }
        double[] x = new double[n];
        px.copyTo(x, 0);
        int[] iflag = new int[]{0};
        int[] iprint = new int[]{-1};
        double[] diag = new double[n];
        this.m_nfailed = 0;
        double fmin = this.m_fcur.getValue();
        double fprev = 0.0;
        double fcur = fmin;
        boolean failed = false;
        boolean success = false;
        IFunctionDerivatives df = null;
        do {
            try {
                success = false;
                if (!failed) {
                    df = this.m_fn.getDerivatives(this.m_fcur);
                }
                this.m_lbfgs.lbfgs(n, this.m_m, x, failed ? 2.0 * Math.abs(fcur) : fcur, df.getGradient(), false, diag, iprint, this.m_gtol, this.m_xtol, iflag);
                DataBlock rx = new DataBlock(x);
                if (iflag[0] == 0) {
                    this.m_fcur = this.m_fn.evaluate(rx);
                    break;
                }
                if (iflag[0] != 1) {
                    return false;
                }
                if (!this.m_fn.getDomain().checkBoundaries(rx)) {
                    failed = true;
                    continue;
                }
                IFunctionInstance efn = this.m_fn.evaluate(rx);
                fcur = efn.getValue();
                if (fcur <= fmin) {
                    fprev = fmin;
                    fmin = fcur;
                    this.m_fcur = efn;
                    this.m_converged = Math.abs(fprev - fmin) < (1.0 + Math.abs(fmin)) * this.m_eps;
                    success = true;
                }
                failed = false;
            }
            catch (RuntimeException ex) {
                failed = true;
            }
        } while (this.next(failed, success));
        return this.m_converged;
    }

    protected boolean next(boolean failed, boolean success) {
        if (success && this.hasHooks()) {
            IProcessingHook.HookInformation<LbfgsMinimizer, IFunctionInstance> hinfo = new IProcessingHook.HookInformation<LbfgsMinimizer, IFunctionInstance>(this, this.m_fcur);
            this.processHooks(hinfo, true);
            if (hinfo.cancel) {
                return false;
            }
        }
        if (failed) {
            return this.m_nfailed++ <= 100;
        }
        this.m_nfailed = 0;
        return this.m_lbfgs.getNIter() <= this.m_maxiter && !this.m_converged;
    }

    @Override
    public void setConvergenceCriterion(double value) {
        this.m_eps = value;
    }

    public void setGTol(double value) {
        this.m_gtol = value;
    }

    @Override
    public void setMaxIter(int val) {
        this.m_maxiter = val;
    }

    public void setXTol(double value) {
        this.m_xtol = value;
    }

    public int getMemoryLength() {
        return this.m_m;
    }

    public void setMemoryLength(int m) {
        this.m_m = m;
    }
}

