/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.x13;

import ec.satoolkit.AbstractSaSpecification;
import ec.satoolkit.DecompositionMode;
import ec.satoolkit.IDefaultSeriesDecomposer;
import ec.satoolkit.ISaSpecification;
import ec.satoolkit.algorithm.implementation.X13ProcessingFactory;
import ec.satoolkit.benchmarking.SaBenchmarkingSpec;
import ec.satoolkit.x11.X11Specification;
import ec.satoolkit.x13.X11Decomposer;
import ec.satoolkit.x13.X13Exception;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.modelling.DefaultTransformationType;
import ec.tstoolkit.modelling.arima.IPreprocessor;
import ec.tstoolkit.modelling.arima.x13.RegArimaSpecification;
import ec.tstoolkit.modelling.arima.x13.TradingDaysSpec;
import java.util.Map;
import java.util.Objects;

public class X13Specification
extends AbstractSaSpecification
implements ISaSpecification,
Cloneable {
    public static final String REGARIMA = "regarima";
    public static final String X11 = "x11";
    public static final String BENCH = "benchmarking";
    public static final String RSA = "method";
    private static final String SMETHOD = "X13";
    private RegArimaSpecification regSpec_;
    private X11Specification x11Spec_;
    private SaBenchmarkingSpec benchSpec_;
    public static final X13Specification RSAX11;
    public static final X13Specification RSA0;
    public static final X13Specification RSA1;
    public static final X13Specification RSA2;
    public static final X13Specification RSA3;
    public static final X13Specification RSA4;
    public static final X13Specification RSA5;

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        RegArimaSpecification.fillDictionary(InformationSet.item(prefix, REGARIMA), dic);
        X11Specification.fillDictionary(InformationSet.item(prefix, X11), dic);
        SaBenchmarkingSpec.fillDictionary(InformationSet.item(prefix, BENCH), dic);
    }

    public static final X13Specification[] allSpecifications() {
        return new X13Specification[]{RSAX11, RSA0, RSA1, RSA2, RSA3, RSA4, RSA5};
    }

    public X13Specification() {
        this.regSpec_ = new RegArimaSpecification();
        this.x11Spec_ = new X11Specification();
        this.benchSpec_ = new SaBenchmarkingSpec();
    }

    public X13Specification(RegArimaSpecification regSpec, X11Specification x11Spec) {
        this.regSpec_ = regSpec;
        this.x11Spec_ = x11Spec;
        this.benchSpec_ = new SaBenchmarkingSpec();
    }

    @Override
    public X13Specification clone() {
        try {
            X13Specification spec = (X13Specification)super.clone();
            spec.regSpec_ = this.regSpec_.clone();
            spec.x11Spec_ = this.x11Spec_.clone();
            spec.benchSpec_ = this.benchSpec_.clone();
            return spec;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public RegArimaSpecification getRegArimaSpecification() {
        return this.regSpec_;
    }

    public void setRegArimaSpecification(RegArimaSpecification regSpec_) {
        this.regSpec_ = regSpec_;
    }

    public X11Specification getX11Specification() {
        return this.x11Spec_;
    }

    public void setX11Specification(X11Specification x11Spec_) {
        this.x11Spec_ = x11Spec_;
    }

    public SaBenchmarkingSpec getBenchmarkingSpecification() {
        return this.benchSpec_;
    }

    public void setBenchmarkingSpecification(SaBenchmarkingSpec benchSpec) {
        if (benchSpec == null) {
            throw new IllegalArgumentException(BENCH);
        }
        this.benchSpec_ = benchSpec;
    }

    public IPreprocessor buildPreprocessor() {
        return this.regSpec_.build();
    }

    public IDefaultSeriesDecomposer buildDecomposer() {
        return new X11Decomposer(this.x11Spec_);
    }

    @Override
    protected void checkContext(ProcessingContext context) {
        if (this.regSpec_.getRegression() == null) {
            return;
        }
        int nregs = this.regSpec_.getRegression().getUserDefinedVariablesCount();
        if (nregs > 0 && !X13Specification.checkVariables(this.regSpec_.getRegression().getUserDefinedVariables(), context)) {
            throw new X13Exception("Invalid context");
        }
        TradingDaysSpec td = this.regSpec_.getRegression().getTradingDays();
        if (td == null) {
            return;
        }
        if (!X13Specification.checkVariables(td.getUserVariables(), context)) {
            throw new X13Exception("Invalid context");
        }
        if (!X13Specification.checkCalendar(td.getHolidays(), context)) {
            throw new X13Exception("Invalid context");
        }
    }

    public static X13Specification fromString(String name) {
        if (name.equals("X11")) {
            return RSAX11;
        }
        if (name.equals("RSA0")) {
            return RSA0;
        }
        if (name.equals("RSA1")) {
            return RSA1;
        }
        if (name.equals("RSA2c")) {
            return RSA2;
        }
        if (name.equals("RSA3")) {
            return RSA3;
        }
        if (name.equals("RSA4c")) {
            return RSA4;
        }
        if (name.equals("RSA5c")) {
            return RSA5;
        }
        return new X13Specification();
    }

    public boolean isSystem() {
        return this == RSAX11 || this == RSA0 || this == RSA1 || this == RSA2 || this == RSA3 || this == RSA4 || this == RSA5;
    }

    public X13Specification matchSystem() {
        if (this.isSystem()) {
            return this;
        }
        if (this.equals(RSAX11)) {
            return RSAX11;
        }
        if (this.equals(RSA0)) {
            return RSA0;
        }
        if (this.equals(RSA1)) {
            return RSA1;
        }
        if (this.equals(RSA2)) {
            return RSA2;
        }
        if (this.equals(RSA3)) {
            return RSA3;
        }
        if (this.equals(RSA4)) {
            return RSA4;
        }
        if (this.equals(RSA5)) {
            return RSA5;
        }
        return null;
    }

    public String toString() {
        if (this == RSAX11) {
            return "X11";
        }
        if (this == RSA0) {
            return "RSA0";
        }
        if (this == RSA1) {
            return "RSA1";
        }
        if (this == RSA2) {
            return "RSA2c";
        }
        if (this == RSA3) {
            return "RSA3";
        }
        if (this == RSA4) {
            return "RSA4c";
        }
        if (this == RSA5) {
            return "RSA5c";
        }
        if (this.equals(RSAX11)) {
            return "X11";
        }
        if (this.equals(RSA0)) {
            return "RSA0";
        }
        if (this.equals(RSA1)) {
            return "RSA1";
        }
        if (this.equals(RSA2)) {
            return "RSA2c";
        }
        if (this.equals(RSA3)) {
            return "RSA3";
        }
        if (this.equals(RSA4)) {
            return "RSA4c";
        }
        if (this.equals(RSA5)) {
            return "RSA5c";
        }
        return SMETHOD;
    }

    @Override
    public String toLongString() {
        String s = this.toString();
        if (s.length() == 0) {
            return SMETHOD;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("X13[").append(s).append(']');
        return builder.toString();
    }

    private boolean getrsa(InformationSet pinfo) {
        String rsa = pinfo.get(RSA, String.class);
        if (rsa != null) {
            RegArimaSpecification.Default option = RegArimaSpecification.Default.valueOf(rsa);
            switch (option) {
                case RG0: {
                    this.regSpec_ = RegArimaSpecification.RG0.clone();
                    return true;
                }
                case RG1: {
                    this.regSpec_ = RegArimaSpecification.RG1.clone();
                    return true;
                }
                case RG2: {
                    this.regSpec_ = RegArimaSpecification.RG2.clone();
                    return true;
                }
                case RG3: {
                    this.regSpec_ = RegArimaSpecification.RG3.clone();
                    return true;
                }
                case RG4: {
                    this.regSpec_ = RegArimaSpecification.RG4.clone();
                    return true;
                }
                case RG5: {
                    this.regSpec_ = RegArimaSpecification.RG5.clone();
                    return true;
                }
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof X13Specification && this.equals((X13Specification)obj);
    }

    private boolean equals(X13Specification spec) {
        return Objects.equals(spec.regSpec_, this.regSpec_) && Objects.equals(spec.x11Spec_, this.x11Spec_) && Objects.equals(spec.benchSpec_, this.benchSpec_);
    }

    public int hashCode() {
        int hash = 3;
        hash = 47 * hash + Objects.hashCode(this.regSpec_);
        hash = 47 * hash + Objects.hashCode(this.x11Spec_);
        return hash;
    }

    @Override
    public InformationSet write(boolean verbose) {
        InformationSet binfo;
        InformationSet sinfo;
        InformationSet specInfo = new InformationSet();
        specInfo.add("algorithm", X13ProcessingFactory.DESCRIPTOR);
        InformationSet tinfo = this.regSpec_.write(verbose);
        if (tinfo != null) {
            specInfo.add(REGARIMA, tinfo);
        }
        if ((sinfo = this.x11Spec_.write(verbose)) != null) {
            specInfo.add(X11, sinfo);
        }
        if ((binfo = this.benchSpec_.write(verbose)) != null) {
            specInfo.add(BENCH, binfo);
        }
        return specInfo;
    }

    @Override
    public boolean read(InformationSet info) {
        boolean tok;
        boolean tok2;
        boolean tok3;
        InformationSet tinfo = info.getSubSet(REGARIMA);
        if (tinfo != null && !(tok3 = this.regSpec_.read(tinfo))) {
            return false;
        }
        InformationSet sinfo = info.getSubSet(X11);
        if (sinfo != null && !(tok2 = this.x11Spec_.read(sinfo))) {
            return false;
        }
        InformationSet binfo = info.getSubSet(BENCH);
        return binfo == null || (tok = this.benchSpec_.read(binfo));
    }

    public void checkMode() {
        if (!this.regSpec_.getBasic().isPreprocessing()) {
            return;
        }
        DefaultTransformationType fn = this.regSpec_.getTransform().getFunction();
        switch (fn) {
            case Log: {
                if (!this.x11Spec_.getMode().isMultiplicative()) {
                    this.x11Spec_.setMode(DecompositionMode.Multiplicative);
                }
                return;
            }
            case None: {
                if (this.x11Spec_.getMode() != DecompositionMode.Additive && this.x11Spec_.getMode() != DecompositionMode.PseudoAdditive) {
                    this.x11Spec_.setMode(DecompositionMode.Additive);
                }
                return;
            }
        }
        if (this.x11Spec_.getMode() != DecompositionMode.PseudoAdditive) {
            this.x11Spec_.setMode(DecompositionMode.Undefined);
        }
    }

    static {
        X11Specification xdef = new X11Specification();
        X11Specification x11 = new X11Specification();
        x11.setMode(DecompositionMode.Multiplicative);
        x11.setForecastHorizon(0);
        RSAX11 = new X13Specification(RegArimaSpecification.RGDISABLED, x11);
        RSA0 = new X13Specification(RegArimaSpecification.RG0, xdef);
        RSA1 = new X13Specification(RegArimaSpecification.RG1, xdef);
        RSA2 = new X13Specification(RegArimaSpecification.RG2, xdef);
        RSA3 = new X13Specification(RegArimaSpecification.RG3, xdef);
        RSA4 = new X13Specification(RegArimaSpecification.RG4, xdef);
        RSA5 = new X13Specification(RegArimaSpecification.RG5, xdef);
    }
}

