/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic;

import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class ClusterSplitMergeOperator
extends SimpleMCMCOperator {
    public static final boolean DEBUG = false;
    public static final String CLUSTER_SPLIT_MERGE_OPERATOR = "clusterSplitMergeOperator";
    private final int N;
    private int K;
    private final Parameter allocationParameter;
    private final MatrixParameter clusterLocations;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String CHI = "chi";
        public static final String LIKELIHOOD = "likelihood";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), new ElementRule(Parameter.class), new ElementRule("locations", new XMLSyntaxRule[]{new ElementRule(MatrixParameter.class)})};

        @Override
        public String getParserName() {
            return ClusterSplitMergeOperator.CLUSTER_SPLIT_MERGE_OPERATOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getDoubleAttribute("weight");
            Parameter parameter = (Parameter)xMLObject.getChild(Parameter.class);
            MatrixParameter matrixParameter = (MatrixParameter)xMLObject.getElementFirstChild("locations");
            return new ClusterSplitMergeOperator(parameter, matrixParameter, d);
        }

        @Override
        public String getParserDescription() {
            return "An operator that splits and merges clusters.";
        }

        @Override
        public Class getReturnType() {
            return ClusterSplitMergeOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public ClusterSplitMergeOperator(Parameter parameter, MatrixParameter matrixParameter, double d) {
        this.allocationParameter = parameter;
        this.clusterLocations = matrixParameter;
        this.N = parameter.getDimension();
        this.setWeight(d);
    }

    @Override
    public Parameter getParameter() {
        return this.allocationParameter;
    }

    public Variable getVariable() {
        return this.allocationParameter;
    }

    @Override
    public final double doOperation() {
        Parameter parameter;
        int n;
        int n2;
        boolean bl;
        int n3;
        int n4;
        int[] nArray = new int[this.allocationParameter.getDimension()];
        int[] nArray2 = new int[this.N];
        int[] nArray3 = new int[this.N];
        for (n4 = 0; n4 < nArray3.length; ++n4) {
            nArray3[n4] = -1;
        }
        n4 = 0;
        for (n3 = 0; n3 < nArray.length; ++n3) {
            nArray[n3] = (int)this.allocationParameter.getParameterValue(n3);
            int n5 = nArray[n3];
            nArray2[n5] = nArray2[n5] + 1;
            if (nArray2[nArray[n3]] != 1) continue;
            nArray3[n4] = nArray[n3];
            ++n4;
        }
        n3 = this.clusterLocations.getParameter(0).getDimension();
        double[] dArray = new double[n3];
        double d = 1.0;
        double d2 = 0.5;
        boolean bl2 = bl = n4 == 1 || n4 != this.N && MathUtils.nextBoolean();
        if (bl) {
            while (nArray2[n2 = nArray3[MathUtils.nextInt(n4)]] == 0) {
            }
            n = 0;
            while (nArray2[n] > 0) {
                ++n;
            }
            int n6 = nArray2[n2];
            do {
                nArray2[n2] = 0;
                nArray2[n] = 0;
                for (int i = 0; i < nArray.length; ++i) {
                    boolean bl3;
                    if (nArray[i] != n2 && nArray[i] != n) continue;
                    boolean bl4 = bl3 = MathUtils.nextDouble() < d2;
                    if (bl3) {
                        nArray[i] = n;
                        int n7 = n;
                        nArray2[n7] = nArray2[n7] + 1;
                        continue;
                    }
                    nArray[i] = n2;
                    int n8 = n2;
                    nArray2[n8] = nArray2[n8] + 1;
                }
            } while (nArray2[n2] != 0 && nArray2[n] != 0);
            ++n4;
            parameter = this.clusterLocations.getParameter(n2);
            Parameter parameter2 = this.clusterLocations.getParameter(n);
            double[] dArray2 = parameter.getParameterValues();
            for (int i = 0; i < parameter.getDimension(); ++i) {
                dArray[i] = MathUtils.nextGaussian();
                parameter.setParameterValue(i, dArray2[i] + dArray[i] * d);
                parameter2.setParameterValue(i, dArray2[i] - dArray[i] * d);
            }
        } else {
            n2 = nArray3[MathUtils.nextInt(n4)];
            while (n2 == (n = nArray3[MathUtils.nextInt(n4)])) {
            }
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] != n) continue;
                nArray[i] = n2;
                int n9 = n2;
                nArray2[n9] = nArray2[n9] + 1;
                int n10 = n;
                nArray2[n10] = nArray2[n10] - 1;
            }
            --n4;
            Parameter parameter3 = this.clusterLocations.getParameter(n2);
            parameter = this.clusterLocations.getParameter(n);
            for (int i = 0; i < parameter3.getDimension(); ++i) {
                double d3 = (parameter3.getParameterValue(i) + parameter.getParameterValue(i)) / 2.0;
                dArray[i] = (parameter3.getParameterValue(i) - d3) / d;
                parameter3.setParameterValue(i, d3);
            }
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n = (int)this.allocationParameter.getParameterValue(n2);
            if (nArray[n2] == n) continue;
            this.allocationParameter.setParameterValue(n2, nArray[n2]);
        }
        return 0.0;
    }

    @Override
    public final String getOperatorName() {
        return "clusterSplitMergeOperator(" + this.allocationParameter.getId() + ")";
    }

    public final void optimize(double d) {
        throw new RuntimeException("This operator cannot be optimized!");
    }

    public boolean isOptimizing() {
        return false;
    }

    public void setOptimizing(boolean bl) {
        throw new RuntimeException("This operator cannot be optimized!");
    }

    public double getMinimumAcceptanceLevel() {
        return 0.1;
    }

    public double getMaximumAcceptanceLevel() {
        return 0.4;
    }

    public double getMinimumGoodAcceptanceLevel() {
        return 0.2;
    }

    public double getMaximumGoodAcceptanceLevel() {
        return 0.3;
    }

    public String getPerformanceSuggestion() {
        if (this.getAcceptanceProbability() < this.getMinimumAcceptanceLevel()) {
            return "";
        }
        if (this.getAcceptanceProbability() > this.getMaximumAcceptanceLevel()) {
            return "";
        }
        return "";
    }

    public String toString() {
        return this.getOperatorName();
    }

    public int getStepCount() {
        return 1;
    }
}

