

/*
Adapted from https:

See also src/imp/msp430.rs.

Refs:
- MSP430x5xx and MSP430x6xx Family User's Guide, Rev. Q
  https:

Generated asm:
- msp430 https:
*/

#[cfg(not(portable_atomic_no_asm))]
use core::arch::asm;

pub(super) use super::super::msp430 as atomic;

pub(super) type State = u16;


#[inline(always)]
pub(super) fn disable() -> State {
    let sr: State;
    
    
    unsafe {
        
        
        // See "NOTE: Enable and Disable Interrupt" of User's Guide for NOP: https://www.ti.com/lit/ug/slau208q/slau208q.pdf#page=60
        #[cfg(not(portable_atomic_no_asm))]
        asm!(
            "mov r2, {sr}", 
            "dint {{ nop",  
            sr = out(reg) sr,
            options(nostack),
        );
        #[cfg(portable_atomic_no_asm)]
        {
            llvm_asm!("mov r2, $0" : "=r"(sr) ::: "volatile");
            llvm_asm!("dint { nop" ::: "memory" : "volatile");
        }
    }
    sr
}



/// # Safety


#[inline(always)]
pub(super) unsafe fn restore(prev_sr: State) {
    
    unsafe {
        
        
        
        
        
        
        
        
        
        // See "NOTE: Enable and Disable Interrupt" of User's Guide for NOP: https://www.ti.com/lit/ug/slau208q/slau208q.pdf#page=60
        #[cfg(not(portable_atomic_no_asm))]
        asm!(
            "nop {{ mov {prev_sr}, r2 {{ nop", 
            prev_sr = in(reg) prev_sr,
            options(nostack),
        );
        #[cfg(portable_atomic_no_asm)]
        llvm_asm!("nop { mov $0, r2 { nop" :: "r"(prev_sr) : "memory" : "volatile");
    }
}
