


use super::{Either, Left, Right};









pub trait IntoEither: Sized {
    
    
    
    
    
    /// # Examples
    
    
    
    
    
    
    
    
    fn into_either(self, into_left: bool) -> Either<Self, Self> {
        if into_left {
            Left(self)
        } else {
            Right(self)
        }
    }

    
    
    
    
    
    /// # Examples
    
    
    
    
    
    
    
    
    
    
    
    
    fn into_either_with<F>(self, into_left: F) -> Either<Self, Self>
    where
        F: FnOnce(&Self) -> bool,
    {
        let into_left = into_left(&self);
        self.into_either(into_left)
    }
}

impl<T> IntoEither for T {}
