# Extracted from test-CFI.R:354

# setup ------------------------------------------------------------------------
library(testthat)
test_env <- simulate_test_env(package = "xplainfi", path = "..")
attach(test_env, warn.conflicts = FALSE)

# test -------------------------------------------------------------------------
skip_if_not_installed("knockoff")
task = sim_dgp_correlated(n = 50)
learner = lrn("regr.rpart")
measure = msr("regr.mse")
resampling = rsmp("subsampling", repeats = 5)
gaussian_sampler = KnockoffGaussianSampler$new(task)
cfi = CFI$new(
		task = task,
		learner = learner,
		measure = measure,
		resampling = resampling,
		sampler = gaussian_sampler,
		n_repeats = 1L
	)
cfi$compute()
expect_warning(
		cpi_result <- cfi$importance(ci_method = "cpi"),
		regexp = "multiple test sets"
	)
