% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sage-internals.R
\name{sage_batch_predict}
\alias{sage_batch_predict}
\title{Batch Predict for SAGE}
\usage{
sage_batch_predict(learner, combined_data, task, batch_size, task_type)
}
\arguments{
\item{learner}{(\code{\link[mlr3:Learner]{Learner}}) Trained mlr3 learner.}

\item{combined_data}{(\code{data.table}) Data with feature columns to predict on.}

\item{task}{(\code{\link[mlr3:Task]{Task}}) mlr3 task object.}

\item{batch_size}{(\code{integer(1)} or \code{NULL}) Batch size for predictions. If \code{NULL} or if
\code{total_rows <= batch_size}, processes all data at once.}

\item{task_type}{(\code{character(1)}) Task type, either \code{"classif"} or \code{"regr"}.}
}
\value{
For classification: \code{matrix} of class probabilities (n_rows x n_classes).
For regression: \code{numeric} vector of predictions (length n_rows).
}
\description{
Performs batched prediction on combined data to manage memory usage.
Supports both classification (probability predictions) and regression.
}
\keyword{internal}
