% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{whapi_send_location}
\alias{whapi_send_location}
\title{Send a geographic location via Whapi.Cloud}
\usage{
whapi_send_location(
  to,
  latitude,
  longitude,
  name = NULL,
  address = NULL,
  token = Sys.getenv("WHAPI_TOKEN", unset = ""),
  timeout = 30,
  verbose = TRUE
)
}
\arguments{
\item{to}{Character(1). WhatsApp target (E.164 digits only, no "+") or chat id.}

\item{latitude}{Numeric(1). Latitude in decimal degrees (range: -90..90).}

\item{longitude}{Numeric(1). Longitude in decimal degrees (range: -180..180).}

\item{name}{Optional character(1). Short title for the location.}

\item{address}{Optional character(1). Human-readable address/description.}

\item{token}{Bearer token (defaults to env var \code{WHAPI_TOKEN}).}

\item{timeout}{Numeric. Request timeout (seconds). Default 30.}

\item{verbose}{Logical. Print CLI messages? Default TRUE.}
}
\value{
A tibble with \code{id}, \code{to}, \code{status}, \code{timestamp}, \code{timestamp_dt}, and raw \code{resp}.
}
\description{
Sends a location message using Whapi's \code{POST /messages/location}.
Supports optional \code{name} (short title) and \code{address} (human-readable).
}
\examples{
\dontrun{
 Sys.setenv(WHAPI_TOKEN = "your_token_here")
 whapi_send_location("5581999999999",
   latitude = -8.063169, longitude = -34.871139,
   name = "Marco Zero", address = "Recife, PE")

# Group id example
 whapi_send_location("1203630xxxxxxxx@g.us", -8.045, -34.91)
}
}
