% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{whapi_get_contact_profile}
\alias{whapi_get_contact_profile}
\title{Get WhatsApp contact profile(s) via Whapi.Cloud}
\usage{
whapi_get_contact_profile(
  contacts,
  token = Sys.getenv("WHAPI_TOKEN", unset = ""),
  full = TRUE,
  timeout = 30,
  verbose = TRUE
)
}
\arguments{
\item{contacts}{Character vector. Phones in E.164 digits (no "+") or chat IDs.}

\item{token}{Bearer token. Defaults to env var \code{WHAPI_TOKEN}.}

\item{full}{Logical. If \code{TRUE}, add \verb{_full=true} query param. Default \code{TRUE}.}

\item{timeout}{Numeric. Request timeout (seconds). Default \code{30}.}

\item{verbose}{Logical. Print progress with \pkg{cli}? Default \code{TRUE}.}
}
\value{
A tibble with one row per contact:
\itemize{
\item \code{contact_id} (input id or JID as queried),
\item \code{name}, \code{about}, \code{icon}, \code{icon_full},
\item \code{resp} with the raw response (list).
}
}
\description{
Fetches profile information for one or more contacts using
\code{GET /contacts/{ContactID}/profile} and returns a tidy tibble.
This version assumes the response body contains:
\itemize{
\item \code{name} (string, user name),
\item \code{about} (string, user info in About section),
\item \code{icon} (string, profile preview icon URL),
\item \code{icon_full} (string, full avatar URL).
}
}
\details{
\itemize{
\item Each \code{contacts} element may be a phone number (free text) or a JID
(e.g., \code{"1203...@g.us"}). Phone numbers are normalized via
\code{\link[=whapi_normalize_to]{whapi_normalize_to()}} (12 digits total); JIDs are kept as-is.
\item When \code{full = TRUE}, \verb{_full=true} is added to the querystring to request
higher-resolution avatars (if supported).
}
}
\examples{
\dontrun{

 Sys.setenv(WHAPI_TOKEN = "your_token_here")
# Single:
 whapi_get_contact_profile("5581999999999")

# Mixed (number + group JID):
 whapi_get_contact_profile(c("5581999999999", "1203630xxxxxx@g.us"))
}

}
