% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcs_delay.R
\name{mcs_delay_report}
\alias{mcs_delay_report}
\title{Adjustment of Operating Times by Delays in Report using a Monte Carlo Approach}
\usage{
mcs_delay_report(
  date_repair,
  date_report,
  time,
  status,
  distribution = "lognormal",
  details = FALSE
)
}
\arguments{
\item{date_repair}{a vector of class \code{character} or \code{Date}, in the
format "yyyy-mm-dd", indicating the date of repair of a failed unit.
Use \code{NA} for missing elements.}

\item{date_report}{a vector of class \code{character} or \code{Date}, in the
format "yyyy-mm-dd", indicating the date of report of a failed unit.
Use \code{NA} for missing elements.}

\item{time}{A numeric vector of operating times.}

\item{status}{A vector of binary data (0 or 1) indicating whether unit \emph{i} is
a right censored observation (= 0) or a failure (= 1).}

\item{distribution}{Supposed distribution of the random variable. Only
\code{"lognormal"}is implemented.}

\item{details}{A logical. If \code{FALSE} the output consists of a vector with
corrected operating times for the censored units and the input operating
times for the failed units. If \code{TRUE} the output consists of a detailed
list, i.e the same vector as described before, simulated random numbers and
estimated distribution parameters.}
}
\value{
A numeric vector of corrected operating times for the censored units
and the input operating times for the failed units if \code{details = FALSE}.
If \code{details = TRUE} the output is a list which consists of the following
elements:
\itemize{
\item \code{time} : Numeric vector of corrected operating times for the censored
observations and input operating times for failed units.
\item \code{x_sim} : Simulated random numbers of specified distribution with
estimated parameters. The length of \code{x_sim} is equal to the number of
censored observations.
\item \code{coefficients} : Estimated coefficients of supposed distribution.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#soft-deprecated}{\figure{lifecycle-soft-deprecated.svg}{options: alt='[Soft-deprecated]'}}}{\strong{[Soft-deprecated]}}

\code{mcs_delay_report()} is no longer under active development, switching to
\link{mcs_delay} is recommended.
}
\details{
The delay in report describes the time between the occurrence of a damage and
the registration in the warranty database. For a given date where the analysis
is made there could be units which had a failure but are not registered in the
database and therefore treated as censored units. To overcome this problem
this function uses a Monte Carlo approach for simulating the operating
times of (multiple) right censored observations, taking account of reporting
delays. The simulation is based on the distribution of operating times that were
calculated from complete data, i.e. failed items (see \link{dist_delay_report}).
}
\examples{
date_of_repair <- c(NA, "2014-09-15", "2015-07-04", "2015-04-10", NA,
                   NA, "2015-04-24", NA, "2015-04-25", "2015-04-24",
                    "2015-06-12", NA, "2015-05-04", NA, NA,
                    "2015-05-22", NA, "2015-09-17", NA, "2015-08-15",
                    "2015-11-26", NA, NA)

date_of_report <- c(NA, "2014-10-09", "2015-08-28", "2015-04-15", NA,
                    NA, "2015-05-16", NA, "2015-05-28", "2015-05-15",
                    "2015-07-11", NA, "2015-08-14", NA, NA,
                    "2015-06-05", NA, "2015-10-17", NA, "2015-08-21",
                    "2015-12-02", NA, NA)

op_time <- rep(1000, length(date_of_repair))
status <- c(0, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 0, 1, 0, 0, 1, 0, 1, 0, 1, 1, 0, 0)

# Example 1 - Simplified vector output:
x_corrected <- mcs_delay_report(
  date_repair = date_of_repair,
  date_report = date_of_report,
  time = op_time,
  status = status,
  distribution = "lognormal",
  details = FALSE
)

# Example 2 - Detailed list output:
list_detail <- mcs_delay_report(
  date_repair = date_of_repair,
  date_report = date_of_report,
  time = op_time,
  status = status,
  distribution = "lognormal",
  details = TRUE
)

}
