% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weightedss.R
\name{weightedss}
\alias{weightedss}
\title{Weighted sum-of-squares criteria}
\usage{
weightedss(X, cl, w = NULL)
}
\arguments{
\item{X}{a matrice or a dataframe of size \code{n} (observations) by \code{p} (variables) 
with numerical features only.}

\item{cl}{a vector of integers of length \code{n}. It contains the cluster membership of the data.}

\item{w}{a numerical vector of length \code{p}. It contains the weights to be applied to the features. 
By default, \code{w=NULL}, which amounts to setting each weight equal to 1.}
}
\value{
\item{bss.per.feature}{a numerical vector of length \code{p} containing the weighted 
between sum-of-squares per feature.}

\item{wss.per.feature}{a numerical vector of length \code{p} containing the weighted 
within sum-of-squares per feature.}

\item{bss.per.cluster}{a numerical vector of length \code{K} (\code{K} is the number of 
clusters) containing the weighted between sum-of-squares per cluster.}

\item{wss.per.cluster}{a numerical vector of length \code{K} 
containing the weighted within sum-of-squares per cluster.}

\item{bss}{a scalar representing the weighted between sum-of-squares of the partition.
It may be computed as the sum over \code{bss.per.feature} or \code{bss.per.cluster}.}

\item{wss}{a scalar representing the weighted within sum-of-squares of the partition.
It may be computed as the sum over \code{wss.per.feature} or \code{wss.per.cluster}.}
}
\description{
This function computes various weighted sum-of-squares criteria for a given
partition of a dataset described by numerical features.
}
\examples{
data(iris)
out <- weightedss(X = iris[,1:4], cl = as.numeric(iris$Species))
out$bss.per.feature
out$bss.per.cluster
out$bss

w <- c(0.3,0.3,0.2,0.2)
out <- weightedss(X = iris[,1:4], cl = as.numeric(iris$Species), w=w)
out$bss.per.feature
out$bss.per.cluster
out$bss
}
