% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{summary_vald_metrics}
\alias{summary_vald_metrics}
\title{Dynamic Summary Table for Performance Metrics}
\usage{
summary_vald_metrics(
  data,
  group_vars = c("sex", "sports"),
  exclude_cols = c("profileId", "athleteId", "testId", "Testdate", "dateofbirth", "age",
    "Weight_on_Test_Day"),
  digits = 2
)
}
\arguments{
\item{data}{Data frame. Test data (typically from \code{split_by_test()}).}

\item{group_vars}{Character vector. Variables to group by. Default is
c("sex", "sports").}

\item{exclude_cols}{Character vector. Column names to exclude from summary
(typically metadata columns). Default includes common ID and date fields.}

\item{digits}{Integer. Number of decimal places for rounding. Default is 2.}
}
\value{
Data frame with summary statistics (Mean, SD, CV, N) for each metric
  and grouping combination.
}
\description{
Creates a comprehensive summary table showing mean, standard deviation,
coefficient of variation, and sample size for all numeric performance metrics.
Can be grouped by test type, sex, sport, or any combination thereof.
}
\details{
Generate Summary Statistics for VALD Metrics
}
\examples{
\donttest{
if (FALSE) {
  test_datasets <- split_by_test(final_analysis_data)
  cmj_summary <- summary_vald_metrics(
    data = test_datasets$CMJ,
    group_vars = c("sex", "sports")
  )
  print(cmj_summary)
}
}
}
