/*-------------------------------------------------------------------------------
 This file is part of unityForest.

 unityForest is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 unityForest is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with unityForest. If not, see <http://www.gnu.org/licenses/>.

 This file is based on the ranger package.

 Original author:
   Marvin N. Wright
   Institut für Medizinische Biometrie und Statistik
   Universität zu Lübeck
   http://www.imbs-luebeck.de

 Modifications and extensions for the unityForest package:
   Roman Hornung
 #-------------------------------------------------------------------------------*/

#ifndef DATASPARSE_H_
#define DATASPARSE_H_

#include <RcppEigen.h>

#include "globals.h"
#include "utility.h"
#include "Data.h"

namespace unityForest
{

  class DataSparse : public Data
  {
  public:
    DataSparse() = default;

    DataSparse(Eigen::SparseMatrix<double> &data, std::vector<std::string> variable_names, size_t num_rows,
               size_t num_cols);

    DataSparse(const DataSparse &) = delete;
    DataSparse &operator=(const DataSparse &) = delete;

    virtual ~DataSparse() override = default;

    double get(size_t row, size_t col) const override
    {
      // Use permuted data for corrected impurity importance
      size_t col_permuted = col;
      if (col >= num_cols)
      {
        col = getUnpermutedVarID(col);
        row = getPermutedSampleID(row);
      }
      return data.coeff(row, col);
    }

    void reserveMemory() override
    {
      data.resize(num_rows, num_cols);
    }

    void set(size_t col, size_t row, double value, bool &error) override
    {
      data.coeffRef(row, col) = value;
    }

  private:
    Eigen::SparseMatrix<double> data;
  };

} // namespace unityForest

#endif /* DATASPARSE_H_ */
