% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{sim_bounded}
\alias{sim_bounded}
\title{Simulated data set}
\format{
\code{\link{data.frame}} with 1300 observations and 5 columns:

\itemize{
\item \code{y1}: simulated response variable with constant shape parameter,
\eqn{\theta = 2}.
\item \code{y2}: simulated response variable with regression structure in
the shape parameter, \eqn{\theta_i = \exp(\zeta_i}), where
\eqn{\zeta_i = \mathbf{z}_i^\top\,\boldsymbol{\gamma}}.
\item \code{x}: covariate related to \eqn{\mu_i}, i.e., the median.
\item \code{z}: covariate related to \eqn{\theta_i}, i.e., the shape parameter.
\item \code{family}: string indicating the family of distribution.
}
}
\usage{
data(sim_bounded, package = "unitquantreg")
}
\description{
This data set was simulated from all families of distributions
available in \code{\link[unitquantreg]{unitquantreg}} package considering
the median, i.e., \eqn{\tau=0.5}.
}
\details{
There are two response variable, namely \code{y1} and \code{y2}.
The former was simulated considering a regression structure for
\eqn{\mu} and one covariate simulated from a standard uniform distribution,
where the true vector of coefficients for \eqn{\mu} is
\eqn{\boldsymbol{\beta} = (1, 2)} and \eqn{\theta = 2}.
The latter was simulated assuming a regression structure for both \eqn{\mu}
and \eqn{\theta} (shape parameter) and only one independent covariates
simulated from two standard uniform distributions. The true vectors of
coefficients for \eqn{\mu} and \eqn{\theta} are
\eqn{\boldsymbol{\beta} = (1, 2)} and \eqn{\boldsymbol{\gamma} = (-1, 1)},
respectively.
}
\author{
André F. B. Menezes
}
\keyword{datasets}
