% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniInfo.R
\name{uniInfo}
\alias{uniInfo}
\title{Create the univariate info for use in uniLasso}
\usage{
uniInfo(
  X,
  y,
  family = c("gaussian", "binomial", "cox"),
  weights = NULL,
  nit = 2,
  loo = FALSE,
  ridge = 0,
  eps = 1e-06
)
}
\arguments{
\item{X}{An n x p feature matrix}

\item{y}{A response object, depending on the family. For "gaussian" it is just a response vector. For "binomial" either a binary vector, a two level factor, or a two column non-negative matrix with rows summing to 1. For "cox" it is a Surv object (currently for right censored data).}

\item{family}{one of "gaussian","binomial" or "cox". Currently only these families are implemented. In the future others
will be added.}

\item{weights}{Vector of non-negative weights. Default is NULL, which results in all weights equal to 1.}

\item{nit}{Number of iterations if Newton steps are required (in "binomial" and "cox"). Default is 2. In principal more is better, but in some cases can run into convergence issues.}

\item{loo}{A logical, default=FALSE. If TRUE it computes the matrix of loo fits F.}

\item{ridge}{A positive number that penalizes the square of the slope parameters. This is useful if some of the variables are nearly constant, or have very small variances. Default is 0.0.}

\item{eps}{A small number to regularize the hessian for "cox"; default is 1e-6.}
}
\value{
a list with components \code{$beta} and \code{$beta0}, and if \code{loo=TRUE}, a n x p matrix \code{F} with the loo fits.
}
\description{
Fit p separate univariate fits,  and if requested computes the loo fit matrix F.
It is called internally by \code{uniLasso}, or can be called externally on separate data and passed as input to \code{uniLasso}.
Currently this function can accommodate "gaussian", "binomial", and "Cox" families.
}
\examples{
# Gaussian model
set.seed(1)
sigma=3
n <- 100; p <- 20
x <- matrix(rnorm(n * p), n, p)
beta <- matrix(c(rep(2, 5), rep(0, 15)), ncol = 1)
y <- x \%*\% beta + rnorm(n)*sigma


info = uniInfo(x,y)
names(info)

yb = as.numeric(y>0)
info = uniInfo(x,yb, family = "binomial", loo = TRUE)
names(info)
}
