% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{timeSeriesGrid}
\alias{timeSeriesGrid}
\title{Plot time series data}
\usage{
timeSeriesGrid(
  object,
  filter.name = "default",
  cut.off = 5,
  min.count = 0,
  min.vaf = 0,
  amplicons = NULL,
  samples = NULL,
  x_variable = NULL,
  y_variable = "Max Non-ref Allele Frequency",
  columns = "Sample Name",
  rows = "Name",
  color_by = "Name",
  fdr = 0.05,
  use.caller = TRUE,
  bed_positions = NULL
)
}
\arguments{
\item{object}{A consensus data table}

\item{filter.name}{"default"}

\item{cut.off}{5}

\item{min.count}{0}

\item{min.vaf}{0}

\item{amplicons}{NULL}

\item{samples}{NULL}

\item{x_variable}{NULL}

\item{y_variable}{"Max Non-ref Allele Frequency"}

\item{columns}{"Sample Name"}

\item{rows}{"Name"}

\item{color_by}{"Name"}

\item{fdr}{0.05}

\item{use.caller}{TRUE}

\item{bed_positions}{NULL}
}
\value{
A ggplot object.
}
\description{
Function for plotting time series or other meta data. Uses facet wrap to
display user-provided categorical variables.
}
\examples{
library(umiAnalyzer)

main <- system.file("extdata", package = "umiAnalyzer")
simsen <- createUmiExperiment(main)
simsen <- filterUmiObject(simsen)

metaData <- system.file("extdata", "metadata.txt", package = "umiAnalyzer")
simsen <- importDesign(object = simsen,file = metaData)

bed_dir <- system.file("extdata", "simple.bed", package = "umiAnalyzer")
bed <- importBedFile(path = bed_dir)

time_plot <- timeSeriesGrid(simsen, x_variable = "time", bed_positions = bed)

}
