% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignment.R
\name{parseBamFiles}
\alias{parseBamFiles}
\title{Function to parse bam files}
\usage{
parseBamFiles(mainDir, sampleNames = NULL, consDepth = 0, as.shiny = FALSE)
}
\arguments{
\item{mainDir}{Directory containing UMIErrorCorrect output folders.}

\item{sampleNames}{A list of sample names.}

\item{consDepth}{Only retain consensus reads of at least cons.depth. Default is 0.}

\item{as.shiny}{Set to TRUE if run within a shiny::withProgress environment}
}
\value{
A data table
}
\description{
Function to parse bam files
}
\examples{
\donttest{
library(umiAnalyzer)
main <- system.file("extdata", package = "umiAnalyzer")
simsen <- createUmiExperiment(main)

reads <- parseBamFiles(main, consDepth = 10)
}

}
