% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{mergeAssays}
\alias{mergeAssays}
\title{Merge assays}
\usage{
mergeAssays(object, name, assay.list)
}
\arguments{
\item{object}{A UMIexperiment object}

\item{name}{Name of the new assay}

\item{assay.list}{List of assays to merge}
}
\value{
merged consensus data
}
\description{
Merge assays together by name. Requires a name of the new assay and
a list of assays that will be merged.
}
\examples{
\donttest{
library(umiAnalyzer)

main <- system.file("extdata", package = "umiAnalyzer")

simsen <- createUmiExperiment(main)

simsen <- mergeAssays(object = simsen,name = "new",assay.list = c("PIK3CA_123", "PIK3CA_234"))
}

}
