% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{filterUmiObject}
\alias{filterUmiObject}
\title{Method for filtering UMIexperiment and sample objects}
\usage{
filterUmiObject(
  object,
  name = "default",
  minDepth = 3,
  minCoverage = 100,
  minFreq = 0,
  minCount = 0
)
}
\arguments{
\item{object}{Requires a UMI sample or UMI experiment object.}

\item{name}{String. Name of the filter. Default is "default".}

\item{minDepth}{Consensus depth to analyze. Default is 3.}

\item{minCoverage}{Minimum coverage required for amplicons. Default is 1.}

\item{minFreq}{Minimum variant allele frequency to keep. Default is 0.}

\item{minCount}{Minimum variant allele count to keep. Default is 3.}
}
\value{
A UMI sample or UMI experiment object.
}
\description{
Method for filtering UMIexperiment and sample objects
}
\examples{
library(umiAnalyzer)

main = system.file('extdata', package = 'umiAnalyzer')

samples <- list.dirs(path = main, full.names = FALSE, recursive = FALSE)

simsen <- createUmiExperiment(experimentName = 'simsen',mainDir = main,sampleNames = samples)

simsen <- filterUmiObject(simsen)

}
