% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_column.R
\name{tt_column}
\alias{tt_column}
\title{Style specific columns}
\usage{
tt_column(
  table,
  column,
  width = NULL,
  align = NULL,
  bold = NULL,
  italic = NULL,
  color = NULL,
  fill = NULL,
  border_left = NULL,
  border_right = NULL,
  font_size = NULL,
  rotate = NULL,
  inset = NULL,
  stroke = NULL,
  .missing = c("warn", "ignore", "error")
)
}
\arguments{
\item{table}{A \code{typst_table} object.}

\item{column}{<\code{\link[tidyselect:language]{tidy-select}}> Column(s) to style.}

\item{width}{Column width (e.g., \code{"100pt"}, \code{"2fr"}). Overrides width set in \code{tt()}.}

\item{align}{Column alignment: \code{"left"}, \code{"center"}, \code{"right"}.}

\item{bold}{Logical, column name, or pattern string. If logical, applies to all rows.
If column name (unquoted), uses that column's values. If pattern containing \code{{col}}
(e.g., \code{"bold_{col}"}), expands to column name per styled column.}

\item{italic}{Logical, column name, or pattern string. Same behavior as \code{bold}.}

\item{color}{Text color. Can be a color value, column name, or pattern string.}

\item{fill}{Fill color. Can be a color value, column name, or pattern string.}

\item{border_left}{Left border specification (e.g., \code{TRUE}, \code{"1pt + gray"}).}

\item{border_right}{Right border specification.}

\item{font_size}{Font size (e.g., \code{"10pt"}, \code{"0.9em"}). Can be a column name or pattern string.}

\item{rotate}{Rotation angle (e.g., \code{"90deg"}, \code{90}, \code{"1.5rad"}). Can be a column name or pattern string.}

\item{inset}{Cell padding (e.g., \code{"10pt"}, \code{"5pt 8pt"}). Can be a column name or pattern string.}

\item{stroke}{Stroke (border) specification for the cell(s). Can be \code{TRUE} for
default 1pt black, a color, a Typst stroke spec like \code{"2pt + blue"}, or a
Typst dictionary like \code{"(bottom: 1pt)"}. Can also be a column name or pattern string.}

\item{.missing}{How to handle missing pattern columns: \code{"warn"} (default) emits a warning,
\code{"ignore"} silently skips, \code{"error"} stops execution.}
}
\value{
The modified \code{typst_table} object.
}
\description{
Applies formatting to one or more columns. Supports both static values and
data-driven formatting where styling parameters reference other columns.
}
\details{
\subsection{Data-driven formatting}{

Style parameters can reference columns in the original data for per-row values:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{data |>
  mutate(bg_color = ifelse(value > 100, "red", "white")) |>
  tt(cols = c(name, value)) |>
  tt_column(value, fill = bg_color)
}\if{html}{\out{</div>}}

The \code{bg_color} column is hidden from display but used for styling.
}

\subsection{Pattern-based styling}{

When styling multiple columns with a naming convention, use \code{{col}} patterns
to automatically expand column references:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Instead of repetitive calls:
data |>
  tt(cols = c(mpg, qsec)) |>
  tt_column(everything(), color = "color_\{col\}", fill = "bg_\{col\}")
}\if{html}{\out{</div>}}

For column \code{mpg}, this looks for \code{color_mpg} and \code{bg_mpg} in the data.
}
}
\examples{
# Right-align and bold a numeric column
tt(mtcars[1:5, 1:3], rownames = FALSE) |>
  tt_column(mpg, align = "right", bold = TRUE)

# Style multiple columns at once
tt(mtcars[1:5, 1:3], rownames = FALSE) |>
  tt_column(c(mpg, disp), align = "right", color = "blue")

# Pattern-based styling (column-specific style columns)
df <- data.frame(
  a = 1:3, b = 4:6,
  color_a = c("red", "green", "blue"),
  color_b = c("black", "gray", "white")
)
tt(df, cols = c(a, b), rownames = FALSE) |>
  tt_column(c(a, b), color = "color_{col}")

}
