% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/season.r
\name{season}
\alias{season}
\title{Get Season Based on a Date}
\usage{
season(input_date)
}
\arguments{
\item{input_date}{A Date or POSIXct object representing the date to determine
the season for. The input must be of class \code{Date} or \code{POSIXct}.}
}
\value{
A factor indicating the season corresponding to the input date. The
factor levels are:
\itemize{
\item "Winter" for December, January, and February.
\item "Spring" for March, April, and May.
\item "Summer" for June, July, and August.
\item "Fall" for September, October, and November.
\item "Undetermined" if the input is not a valid Date or POSIXct object or
if the month is missing.
}
}
\description{
This function determines the season (Winter, Spring, Summer, or Fall) based
on an input date.

The seasons are assigned based on geographic regions similar to how seasons
occur in the United States.

The seasons are determined using the month of the year and
the traditional meteorological definition of seasons (Winter: December,
January, February; Spring: March, April, May; Summer: June, July, August;
Fall: September, October, November).
}
\examples{
# Example usage of the season function
season(as.Date("2025-01-15"))
season(as.POSIXct("2025-07-01 12:00:00"))

}
\author{
Nicolas Foss, Ed.D., MS
}
