% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{judges}
\alias{judges}
\title{judges}
\format{
This data frame contains the following columns:
\describe{
  \item{\code{season}}{Name of season}
  \item{\code{seasonNumber}}{Season number}
  \item{\code{series}}{Top Chef US (listed as US); Top Chef US Masters
           (listed as US Masters); Top Chef Canada (listed as Canada)}
  \item{\code{episode}}{Episode number}
  \item{\code{challengeType}}{Challenge type: qualifying challenge,
             elimination, quickfire, sudden death quickfire, quickfire
             elimination, battle of the sous chefs}
  \item{\code{outcomeType}}{Is the challenge run as a team or as an
  individual?}
  \item{\code{guestJudge}}{Name of guest judge}
  \item{\code{gender}}{Gender of Chef}
  \item{\code{personOfColor}}{Flag for whether the Chef is a person of color.
                   Will be blank if they are not}
  \item{\code{competedOnTC}}{Will have a value of Yes if they competed
  on a season of Top Chef}
  \item{\code{otherShows}}{Information about other shows that this
  individual has appeared on}
}
}
\source{
\url{https://en.wikipedia.org/wiki/Top_Chef}
}
\usage{
data(judges)
}
\description{
A dataset containing information about who were the guest judges for
each challenge
}
\examples{
library(dplyr)
library(tidyr)
judges \%>\%
  filter(guestJudge == "Eric Ripert") \%>\%
  group_by(challengeType) \%>\%
  summarise(n=n())
}
\keyword{datasets}
