% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{episodeinfo}
\alias{episodeinfo}
\title{episodeinfo}
\format{
This data frame contains the following columns:
\describe{
  \item{\code{season}}{Name of season}
  \item{\code{seasonNumber}}{Season number}
  \item{\code{series}}{Top Chef US (listed as US); Top Chef US Masters
                       (listed as US Masters); Top Chef Canada (listed as
                       Canada)}
  \item{\code{overallEpisodeNumber}}{Running number of episode within
                                       the series}
  \item{\code{episode}}{Episode number}
  \item{\code{episodeName}}{Name of episode}
  \item{\code{airDate}}{Date the episode originally aired}
  \item{\code{nCompetitors}}{Number of Chefs still in the competition}
}
}
\source{
\url{https://en.wikipedia.org/wiki/Top_Chef}
}
\usage{
data(episodeinfo)
}
\description{
A dataset containing information about each episode
}
\examples{
library(dplyr)
library(tidyr)
episodeinfo \%>\% filter(season=="World All Stars")
}
\keyword{datasets}
