% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tokenvis.r
\name{create_browser}
\alias{create_browser}
\title{Convert tokens into full texts in an HTML file}
\usage{
create_browser(
  tokens,
  meta = NULL,
  doc_col = "doc_id",
  token_col = "token",
  space_col = NULL,
  doc_nav = NULL,
  token_nav = NULL,
  filename = NULL,
  css_str = NULL,
  header = "",
  subheader = "",
  n = TRUE,
  navfilter = TRUE,
  top_nav = NULL,
  thres_nav = 1,
  colors = NULL,
  style_col1 = "#7D1935",
  style_col2 = "#F5F3EE",
  drop_missing_meta = FALSE
)
}
\arguments{
\item{tokens}{A data.frame with a column for document ids (doc_col)
and a column for tokens (token_col)}

\item{meta}{A data.frame with a column for document_ids (doc_col). All other columns are added
to the browser as document meta}

\item{doc_col}{The name of the document id column}

\item{token_col}{The name of the token column}

\item{space_col}{Optionally, a column with space indications (" ", "\\n", etc.) per token (which is how some NLP parsers indicate spaces)}

\item{doc_nav}{The name of a column (factor or character) in meta, used to create a navigation bar for selecting document groups.}

\item{token_nav}{Alternative to doc_nav, a column in the tokens. Navigation filters will then be used to select documents in which
the value occurs at least once.}

\item{filename}{Name of the output file. Default is temp file}

\item{css_str}{A character string, to be directly added to the css style header}

\item{header}{Optionally, specify the header}

\item{subheader}{Optionally, specify a subheader}

\item{n}{If TRUE, report N in header}

\item{navfilter}{If TRUE (default) enable filtering with nav(igation) bar.}

\item{top_nav}{A number. If token_nav is used, navigation filters will only apply to the top x values with highest token occurence in a document}

\item{thres_nav}{Like top_nav, but specifying a threshold for the minimum number of tokens.}

\item{colors}{Optionally, a vector with color names for the navigation bar. Length has to be identical to
unique non-NA items in the navigation.}

\item{style_col1}{Color of the browser header}

\item{style_col2}{Color of the browser background}

\item{drop_missing_meta}{if TRUE, omit missing meta rows instead of printing empty value}
}
\value{
The name of the file where the browser is saved. Can be opened conveniently from within R using browseUrl()
}
\description{
Convert tokens into full texts in an HTML file
}
\examples{
url = create_browser(sotu_data$tokens, sotu_data$meta, token_col = 'token', header = 'Speeches')

\donttest{
view_browser(url)   ## view browser in the Viewer
}
if (interactive()) {
browseURL(url)     ## view in default webbrowser
}
}
