% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glimpse-Spat.R
\name{glimpse.Spat}
\alias{glimpse.Spat}
\alias{glimpse.SpatRaster}
\alias{glimpse.SpatVector}
\title{Get a nice glimpse of your \verb{Spat*} objects}
\usage{
\method{glimpse}{SpatRaster}(x, width = NULL, ..., n = 10, max_extra_cols = 20)

\method{glimpse}{SpatVector}(x, width = NULL, ..., n = 10, max_extra_cols = 20)
}
\arguments{
\item{x}{A \code{SpatRaster} created with \code{\link[terra:rast]{terra::rast()}} or a \code{SpatVector}
created with \code{\link[terra:vect]{terra::vect()}}.}

\item{width}{Width of output: defaults to the setting of the width option
(if finite) or the width of the console. See \code{\link[dplyr:glimpse]{dplyr::glimpse()}}.}

\item{...}{Arguments passed on to \code{\link[=as_tibble.Spat]{as_tibble()}} methods
for \code{SpatRaster} and \code{SpatVector}. See \code{\link[=as_tibble.SpatRaster]{as_tibble.SpatRaster()}}.}

\item{n}{Maximum number of rows to show.}

\item{max_extra_cols}{Number of extra columns or layers to print abbreviated
information for, if \code{n} is too small for the \verb{Spat*} object.}
}
\value{
original \code{x} is (invisibly) returned, allowing \code{glimpse()} to
be used within a data pipeline.
}
\description{
\code{glimpse()} is like a transposed version of \code{\link[=print]{print()}}: layers/columns run
down the  page, and data runs across. This makes it possible to see every
layer/column in a \verb{Spat*} object.
}
\section{\CRANpkg{terra} equivalent}{


\code{print()}
}

\section{Methods}{


Implementation of the \strong{generic} \code{\link[dplyr:glimpse]{dplyr::glimpse()}} function for
\verb{Spat*}. objects.
}

\examples{

library(terra)

# SpatVector
v <- vect(system.file("extdata/cyl.gpkg", package = "tidyterra"))

v |> glimpse(n = 2)

# Use on a pipeline
v |>
  glimpse() |>
  mutate(a = 30) |>
  # with options
  glimpse(geom = "WKT")

# SpatRaster
r <- rast(system.file("extdata/cyl_elev.tif", package = "tidyterra"))

r |> glimpse()

# Use on a pipeline
r |>
  glimpse() |>
  mutate(b = elevation_m / 100) |>
  # With options
  glimpse(xy = TRUE)
}
\seealso{
\code{\link[tibble:formatting]{tibble::print.tbl_df()}}

Other \CRANpkg{dplyr} verbs that operate on columns:
\code{\link{mutate.Spat}},
\code{\link{pull.Spat}},
\code{\link{relocate.Spat}},
\code{\link{rename.Spat}},
\code{\link{select.Spat}}

Other \CRANpkg{dplyr} methods:
\code{\link{arrange.SpatVector}()},
\code{\link{bind_cols.SpatVector}},
\code{\link{bind_rows.SpatVector}},
\code{\link{count.SpatVector}()},
\code{\link{distinct.SpatVector}()},
\code{\link{filter-joins.SpatVector}},
\code{\link{filter.Spat}},
\code{\link{group-by.SpatVector}},
\code{\link{mutate-joins.SpatVector}},
\code{\link{mutate.Spat}},
\code{\link{pull.Spat}},
\code{\link{relocate.Spat}},
\code{\link{rename.Spat}},
\code{\link{rowwise.SpatVector}()},
\code{\link{select.Spat}},
\code{\link{slice.Spat}},
\code{\link{summarise.SpatVector}()}
}
\concept{dplyr.cols}
\concept{dplyr.methods}
