% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glance-Spat.R
\name{glance.Spat}
\alias{glance.Spat}
\alias{glance.SpatRaster}
\alias{glance.SpatVector}
\title{Glance at an \verb{Spat*} object}
\usage{
\method{glance}{SpatRaster}(x, ...)

\method{glance}{SpatVector}(x, ...)
}
\arguments{
\item{x}{A \code{SpatRaster} created with \code{\link[terra:rast]{terra::rast()}} or a \code{SpatVector}
created with \code{\link[terra:vect]{terra::vect()}}.}

\item{...}{Ignored by this method.}
}
\value{
glance methods always return a one-row data frame. See \strong{Methods}.
}
\description{
Glance accepts a model object and returns a \code{\link[tibble:tibble]{tibble::tibble()}} with exactly
one row of \code{Spat}. The summaries are typically geographic information.
}
\section{Methods}{


Implementation of the \strong{generic} \code{\link[generics:glance]{generics::glance()}} method for
\verb{Spat*}. objects.
}

\examples{

library(terra)

# SpatVector
v <- vect(system.file("extdata/cyl.gpkg", package = "tidyterra"))

glance(v)

# SpatRaster
r <- rast(system.file("extdata/cyl_elev.tif", package = "tidyterra"))

glance(r)

}
\seealso{
\code{\link{glimpse.Spat}}, \code{\link[generics:glance]{generics::glance()}}.

Other \CRANpkg{generics} methods:
\code{\link{required_pkgs.Spat}},
\code{\link{tidy.Spat}}
}
\concept{generics.methods}
