% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count-tally-SpatVector.R
\name{count.SpatVector}
\alias{count.SpatVector}
\alias{tally.SpatVector}
\title{Count the observations in each \code{SpatVector} group}
\usage{
\method{count}{SpatVector}(
  x,
  ...,
  wt = NULL,
  sort = FALSE,
  name = NULL,
  .drop = group_by_drop_default(x),
  .dissolve = TRUE
)

\method{tally}{SpatVector}(x, wt = NULL, sort = FALSE, name = NULL)
}
\arguments{
\item{x}{A \code{SpatVector}.}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Variables to group
by.}

\item{wt}{Not implemented on this method}

\item{sort}{If \code{TRUE}, will show the largest groups at the top.}

\item{name}{The name of the new column in the output.

If omitted, it will default to \code{n}. If there's already a column called \code{n},
it will use \code{nn}. If there's a column called \code{n} and \code{nn}, it'll use
\code{nnn}, and so on, adding \code{n}s until it gets a new name.}

\item{.drop}{Handling of factor levels that don't appear in the data, passed
on to \code{\link[dplyr:group_by]{group_by()}}.

For \code{count()}: if \code{FALSE} will include counts for empty groups (i.e. for
levels of factors that don't exist in the data).

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} For \code{add_count()}: deprecated since it
can't actually affect the output.}

\item{.dissolve}{logical. Should borders between aggregated geometries
be dissolved?}
}
\value{
A \code{SpatVector} object with an additional attribute.
}
\description{
\code{count()} lets you quickly count the unique values of one or more variables:
\itemize{
\item \code{df |> count(a, b)} is roughly equivalent to
\code{df |> group_by(a, b) |> summarise(n = n())}.
\item \code{count()} is paired with \code{tally()}, a lower-level helper that is equivalent
to \code{df |> summarise(n = n())}.
}
}
\section{\CRANpkg{terra} equivalent}{


\code{\link[terra:aggregate]{terra::aggregate()}}
}

\section{Methods}{


Implementation of the \strong{generic} \code{\link[dplyr:count]{dplyr::count()}} family functions for
\code{SpatVector} objects.

\code{\link[=tally]{tally()}} will always return a disaggregated geometry while \code{\link[=count]{count()}} can
handle this. See also \code{\link[=summarise.SpatVector]{summarise.SpatVector()}}.
}

\examples{
\donttest{

library(terra)
f <- system.file("ex/lux.shp", package = "terra")
p <- vect(f)


p |> count(NAME_1, sort = TRUE)

p |> count(NAME_1, sort = TRUE)

p |> count(pop = ifelse(POP < 20000, "A", "B"))

# tally() is a lower-level function that assumes you've done the grouping
p |> tally()

p |>
  group_by(NAME_1) |>
  tally()

# Dissolve geometries by default

library(ggplot2)
p |>
  count(NAME_1) |>
  ggplot() +
  geom_spatvector(aes(fill = n))

# Opt out
p |>
  count(NAME_1, .dissolve = FALSE, sort = TRUE) |>
  ggplot() +
  geom_spatvector(aes(fill = n))
}
}
\seealso{
\code{\link[dplyr:count]{dplyr::count()}}, \code{\link[dplyr:count]{dplyr::tally()}}

Other \CRANpkg{dplyr} verbs that operate on group of rows:
\code{\link{group-by.SpatVector}},
\code{\link{rowwise.SpatVector}()},
\code{\link{summarise.SpatVector}()}

Other \CRANpkg{dplyr} methods:
\code{\link{arrange.SpatVector}()},
\code{\link{bind_cols.SpatVector}},
\code{\link{bind_rows.SpatVector}},
\code{\link{distinct.SpatVector}()},
\code{\link{filter-joins.SpatVector}},
\code{\link{filter.Spat}},
\code{\link{glimpse.Spat}},
\code{\link{group-by.SpatVector}},
\code{\link{mutate-joins.SpatVector}},
\code{\link{mutate.Spat}},
\code{\link{pull.Spat}},
\code{\link{relocate.Spat}},
\code{\link{rename.Spat}},
\code{\link{rowwise.SpatVector}()},
\code{\link{select.Spat}},
\code{\link{slice.Spat}},
\code{\link{summarise.SpatVector}()}
}
\concept{dplyr.groups}
\concept{dplyr.methods}
