% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-reg-to-parsnip.R
\name{fast_regression_parsnip_spec_tbl}
\alias{fast_regression_parsnip_spec_tbl}
\title{Utility Regression call to \code{parsnip}}
\usage{
fast_regression_parsnip_spec_tbl(.parsnip_fns = "all", .parsnip_eng = "all")
}
\arguments{
\item{.parsnip_fns}{The default for this is set to \code{all}. This means that all
of the parsnip \strong{linear regression} functions will be used, for example \code{linear_reg()},
or \code{cubist_rules}. You can also choose to pass a c() vector like \code{c("linear_reg","cubist_rules")}}

\item{.parsnip_eng}{The default for this is set to \code{all}. This means that all
of the parsnip \strong{linear regression engines} will be used, for example \code{lm}, or
\code{glm}. You can also choose to pass a c() vector like \code{c('lm', 'glm')}}
}
\value{
A tibble with an added class of 'fst_reg_spec_tbl'
}
\description{
Creates a tibble of parsnip regression model specifications.
}
\details{
Creates a tibble of parsnip regression model specifications. This will
create a tibble of 46 different regression model specifications which can be
filtered. The model specs are created first and then filtered out. This will
only create models for \strong{regression} problems. To find all of the supported
models in this package you can visit \url{https://www.tidymodels.org/find/parsnip/}
}
\examples{
fast_regression_parsnip_spec_tbl(.parsnip_fns = "linear_reg")
fast_regression_parsnip_spec_tbl(.parsnip_eng = c("lm","glm"))

}
\seealso{
Other Utility: 
\code{\link{check_duplicate_rows}()},
\code{\link{core_packages}()},
\code{\link{create_splits}()},
\code{\link{create_workflow_set}()},
\code{\link{fast_classification_parsnip_spec_tbl}()},
\code{\link{full_internal_make_wflw}()},
\code{\link{install_deps}()},
\code{\link{load_deps}()},
\code{\link{match_args}()},
\code{\link{quantile_normalize}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Utility}
