% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_data.R
\name{drop_data}
\alias{drop_data}
\alias{drop_data.ggplot}
\alias{drop_data.patchwork}
\alias{drop_data.default}
\title{Drop unused data in the plot}
\usage{
drop_data(p)

\method{drop_data}{ggplot}(p)

\method{drop_data}{patchwork}(p)

\method{drop_data}{default}(p)
}
\arguments{
\item{p}{A \code{ggplot} object or a \code{patchwork} object.}
}
\value{
A \code{ggplot} or \code{patchwork} object with unused data points removed.
}
\description{
Drop unused data points from a ggplot or patchwork object while preserving
the plot structure. This function keeps only a single row of data for each
unique combination of used variables, which can significantly reduce the
object size when the original data contains many rows that are not displayed
in the plot (e.g., due to scale limits or filtering).
}
\examples{
library(ggplot2)
library(patchwork)
p <- ggplot(
  data = mtcars,
  aes(x = mpg, y = wt, colour = cyl)
) +
  geom_point() +
  scale_x_continuous(limits = c(10, 30)) +
  scale_y_continuous(limits = c(1, 6))
object.size(p)

p_drop <- drop_data(p)
object.size(p_drop)

p / p_drop
}
