% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexicon_nrc_eil.R
\name{lexicon_nrc_eil}
\alias{lexicon_nrc_eil}
\title{NRC Emotion Intensity Lexicon (aka Affect Intensity Lexicon) v0.5}
\source{
\url{https://saifmohammad.com/WebPages/AffectIntensity.htm}
}
\usage{
lexicon_nrc_eil(
  dir = NULL,
  delete = FALSE,
  return_path = FALSE,
  clean = FALSE,
  manual_download = FALSE
)
}
\arguments{
\item{dir}{Character, path to directory where data will be stored. If
\code{NULL}, \link[rappdirs]{user_cache_dir} will be used to determine path.}

\item{delete}{Logical, set \code{TRUE} to delete dataset.}

\item{return_path}{Logical, set \code{TRUE} to return the path of the dataset.}

\item{clean}{Logical, set \code{TRUE} to remove intermediate files. This can
greatly reduce the size. Defaults to FALSE.}

\item{manual_download}{Logical, set \code{TRUE} if you have manually
downloaded the file and placed it in the folder designated by running
this function with \code{return_path = TRUE}.}
}
\value{
A tibble with 5.814 rows and 3 variables:
\describe{
  \item{term}{An English word}
  \item{score}{Value between 0 and 1}
  \item{AffectDimension}{Indicator for sentiment or emotion: ("anger",
                         "fear", "sadness", "joy")}
}
}
\description{
General purpose English sentiment/emotion lexicon. The NRC Affect Intensity
Lexicon is a list of English words and their associations with four basic
emotions (anger, fear, sadness, joy).
}
\details{
For a given word and emotion X, the scores range from 0 to 1. A score of 1
means that the word conveys the highest amount of emotion X.  A score of 0
means that the word conveys the lowest amount of emotion X.

License required for commercial use. Please contact Saif M. Mohammad
(saif.mohammad@nrc-cnrc.gc.ca).

Citation info:

Details of the lexicon are in this paper.
Word Affect Intensities. Saif M. Mohammad. In Proceedings of the 11th Edition
of the Language Resources and Evaluation Conference (LREC-2018), May 2018,
Miyazaki, Japan.

inproceedings\{LREC18-AIL, \cr
author = \{Mohammad, Saif M.\}, \cr
title = \{Word Affect Intensities\}, \cr
booktitle = \{Proceedings of the 11th Edition of the Language Resources and Evaluation Conference (LREC-2018)\}, \cr
year = \{2018\}, \cr
address=\{Miyazaki, Japan\} \cr
\} \cr
}
\examples{
\dontrun{
lexicon_nrc_eil()

# Custom directory
lexicon_nrc_eil(dir = "data/")

# Deleting dataset
lexicon_nrc_eil(delete = TRUE)

# Returning filepath of data
lexicon_nrc_eil(return_path = TRUE)
}
}
\seealso{
Other lexicon: 
\code{\link{lexicon_afinn}()},
\code{\link{lexicon_bing}()},
\code{\link{lexicon_loughran}()},
\code{\link{lexicon_nrc}()},
\code{\link{lexicon_nrc_vad}()}
}
\concept{lexicon}
\keyword{datasets}
