% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlg_dir.tcltkGUI.R
\name{dlg_dir.tcltkGUI}
\alias{dlg_dir.tcltkGUI}
\title{A Tcl/Tk version of the \{svDialogs\} directory selection dialog box}
\usage{
\method{dlg_dir}{tcltkGUI}(default = getwd(), title = "Choose a directory", ..., gui = .GUI)
}
\arguments{
\item{default}{The path to the default directory that is proposed (e.g.,
current working directory).}

\item{title}{A title to display on top of the dialog box.}

\item{...}{Not used yet.}

\item{gui}{The 'gui' object concerned by this dialog box.}
}
\value{
The path to the selected folder.
}
\description{
Select an existing directory, or create a new one.
}
\examples{
library(svDialogstcltk) # Tcl/Tk dialog boxes are now used by default
\dontrun{
# A quick default directory changer
setwd(dlg_dir(default = getwd())$res)
}
}
\seealso{
\code{\link[svDialogs:dlg_dir]{svDialogs::dlg_dir()}}
}
\concept{Modal dialog box}
\keyword{misc}
