% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/studyStrap.predict.caret.mSSL.R
\name{studyStrap.predict}
\alias{studyStrap.predict}
\title{Study Strap Prediction Function: Makes predictions on object of class "ss"}
\usage{
studyStrap.predict(ss.obj, X)
}
\arguments{
\item{ss.obj}{A model object (of class "ss") fit with studyStrap package (e.g., ss, cmss, sse, merge).}

\item{X}{A dataframe of the study to make predictions on. Must include covariates with the same names as those used to train models.}
}
\value{
Matrix of predictions. Each column are predictions with different weighting schemes.
}
\description{
Study Strap Prediction Function: Makes predictions on object of class "ss"
}
\examples{
##########################
##### Simulate Data ######
##########################

set.seed(1)
# create half of training dataset from 1 distribution
X1 <- matrix(rnorm(2000), ncol = 2) # design matrix - 2 covariates
B1 <- c(5, 10, 15) # true beta coefficients
y1 <- cbind(1, X1) \%*\% B1

# create 2nd half of training dataset from another distribution
X2 <- matrix(rnorm(2000, 1,2), ncol = 2) # design matrix - 2 covariates
B2 <- c(10, 5, 0) # true beta coefficients
y2 <- cbind(1, X2) \%*\% B2

X <- rbind(X1, X2)
y <- c(y1, y2)

study <- sample.int(10, 2000, replace = TRUE) # 10 studies
data <- data.frame( Study = study, Y = y, V1 = X[,1], V2 = X[,2] )

# create target study design matrix for covariate profile similarity weighting and
# accept/reject algorithm (covaraite-matched study strap)
target <- matrix(rnorm(1000, 3, 5), ncol = 2) # design matrix
colnames(target) <- c("V1", "V2")

##########################
##### Model Fitting #####
##########################

# Fit model with 1 Single-Study Learner (SSL): PCA Regression
ssMod1 <- ss(data = data, formula = Y ~.,
            target.study = target,
            bag.size = length(unique(data$Study)), straps = 5, stack = "standard",
            sim.covs = NA, ssl.method = list("pcr"),
            ssl.tuneGrid = list(data.frame("ncomp" = 2)),
            sim.mets = TRUE,
            model = TRUE, customFNs = list() )

#########################
#####  Predictions ######
#########################

preds <- studyStrap.predict(ssMod1, target)
}
